<?php
require_once("../layouts/members/head.php");
?>

<?php
if (isset($_POST['paymentapiupdate'])) {
    $smartupi_token = strip_tags($_POST['smartupi_token']);
    $gateway_Url = strip_tags($_POST['gateway_Url']);
    $parsed_url = parse_url($gateway_Url);
    $host = isset($parsed_url['host']) ? $parsed_url['host'] : $gateway_Url;

    if (!empty($smartupi_token) && !empty($host) && preg_match('/^[a-z0-9.-]+\.[a-z]{2,}$/i', $host)) {
        $paymentapi = json_encode([
            "smartupi_token" => $smartupi_token,
            "gateway_Url" => $host,
        ]);

        $insData = [
            'paymentapi' => $paymentapi,
        ];

        if (db_update("sitedata", $insData, "user_id='" . $user_data['user_id'] . "'")) {
            awal_alert_msg("Payment API Updated Successfully!", 'success', '');
        } else {
            awal_alert_msg("No Any Changes!", 'info');
        }

    } else {
        awal_alert_msg("Please Fill All Valid Details!", 'error');
    }
}
?>
<?php
if (isset($_POST['p4pointsapiupdate'])) {
    $p4points_apikey = strip_tags($_POST['p4points_apikey']);
    $p4points_url = strip_tags($_POST['p4points_url']);
    $cardprintApi_url = strip_tags($_POST['cardprintApi_url']);
    $parsed_url = parse_url($p4points_url);
    $host = isset($parsed_url['host']) ? $parsed_url['host'] : $p4points_url;

    $cardparsed_url = parse_url($cardprintApi_url);
    $cardprintApihost = isset($cardparsed_url['host']) ? $cardparsed_url['host'] : $cardprintApi_url;
    
    if (!empty($p4points_apikey) && !empty($host) && preg_match('/^[a-z0-9.-]+\.[a-z]{2,}$/i', $host)) {
        $p4pointsAPI = json_encode([
            "p4points_apikey" => $p4points_apikey,
            "p4points_url" => $host,
            "cardprintApi_url" => $cardprintApihost,
        ]);

        $insData = [
            'p4pointsAPI' => $p4pointsAPI,
        ];

        if (db_update("sitedata", $insData, "user_id='" . $user_data['user_id'] . "'")) {
            awal_alert_msg("Payment API Updated Successfully!", 'success', '');
        } else {
            awal_alert_msg("No Any Changes!", 'info');
        }

    } else {
        awal_alert_msg("Please Fill All Valid Details!", 'error');
    }
}
?>
<div class="row">
  <div class="col-md-6 mb-2">
    <div class="card text-danger">
      <div class="card-header bg-primary text-white py-2">
        <div class="d-flex align-items-center">
          <span class="mr-auto"><?=file_name()?></span>
        </div>
      </div>
      <div class="p-3">
      <form class="row text-dark" method="POST" action="">
          <input type="hidden" class="form-control" placeholder="Enter URL Without https://" name="gateway_Url" value="<?=paymentapi("gateway_Url")?>" required>
        <div class="col-md-12 mb-3">
          <label>Gateway Token</label>
          <input type="text" class="form-control" placeholder="Enter Api Token" name="smartupi_token" value="<?=paymentapi("smartupi_token")?>" required>
        </div> 
        <div class="col-md-4 mb-3">
          <button type="submit" class="btn btn-primary btn-block" name="paymentapiupdate">Submit</button>
        </div>
      </form>
     </div>
    </div>
  </div>
      <div class="col-md-6 mb-2">
    <div class="card text-danger">
      <div class="card-header bg-primary text-white py-2">
        <div class="d-flex align-items-center">
          <span class="mr-auto">P4Points API Crediential</span>
        </div>
      </div>
      <div class="p-3">
      <form class="row text-dark" method="POST" action="">
        
          <input type="hidden" class="form-control" placeholder="Enter URL Without https://" name="p4points_url" value="<?=p4pointsapi("p4points_url")?>" required>
        <div class="col-md-12 mb-3">
          <label>P4Point ApiKey <i class="fas fa-key text-red"></i></label>
          <input type="text" class="form-control" placeholder="Enter Api Token" name="p4points_apikey" value="<?=p4pointsapi("p4points_apikey")?>" required>
        </div> 
          <input type="hidden" class="form-control bg-primary text-white" placeholder="Enter URL Without https://" name="cardprintApi_url" value="<?=p4pointsapi("cardprintApi_url")?>" required>
        <div class="col-md-4 mb-3">
          <button type="submit" class="btn btn-primary btn-block" name="p4pointsapiupdate">Submit</button>
        </div>
      </form>
     </div>
    </div>
  </div>
</div>


<?php
require_once("../layouts/members/foot.php");
summernote('#noticealert');
?>