<?php
require_once("../layouts/members/head.php");

// Handle User Profile Update
if (isset($_POST['userupdate']) && $user_data['user_id'] > 0) {
    $name = real_escape_string($_POST['name']);
    $company = real_escape_string($_POST['company']);
    $mobile = is_valid_mobile($_POST['mobile']);
    $email = is_valid_email($_POST['email']); 
    $aadhaar = is_valid_aadhaar($_POST['aadhaar']);
    $pan = is_valid_pan($_POST['pan']);
    $is_otp = real_escape_string($_POST['is_otp']);

    if (!empty($name) && !empty($company) && !empty($mobile) && !empty($email) && !empty($aadhaar) && 
        !empty($pan) && !empty($is_otp)) {

        $insData = [
            'name'     => $name,
            'company'  => $company,
            'mobile'   => $mobile,
            'username' => $mobile,
            'email'    => $email,
            'aadhaar'  => $aadhaar,
            'pan'      => $pan,
            'is_otp'   => $is_otp
        ];

        if (db_update("members", $insData, " user_id='" . $user_data['user_id'] . "' ")) {
            $emailmessage = "Dear {$user_data['name']}, Your Profile has been successfully Changed.";
            $whamessage = "Dear {$user_data['name']},\n" .
            "Your Profile has been successfully Changed.\n\n" .
            "Best Regards,\n" .
            "_*{$site_data['brand']}.*_";
                    
            send_sms_credentials($user_data['mobile'],$whamessage);
            send_email($user_data['email'],"Profile Changed",$emailmessage);
            awal_alert_msg("Profile Updated Successfully!", 'success', '');
        } else {
            awal_alert_msg("No Any Changes!", 'info');
        }
    } else {
        awal_alert_msg("Please Fill All Valid Details!", 'error');
    }
}

// Handle Change Password
if (isset($_POST['changepassword']) && $user_data['user_id'] > 0) {
    $currentpassword = strip_tags($_POST['currentpassword']);
    $newpassword = strip_tags($_POST['newpassword']);
    $confirmpassword = strip_tags($_POST['confirmpassword']);

    if (!empty($currentpassword) && !empty($newpassword) && !empty($confirmpassword)) {
        if ($currentpassword == $user_data['password']) {
            if ($newpassword == $confirmpassword) {

                $insData = ['password' => $newpassword];
                if (db_update("members", $insData, " user_id='" . $user_data['user_id'] . "' ")) {
                    $emailmessage = "Dear {$user_data['name']}, Your Password has been successfully Changed. New Password is : $newpassword";
                    $whamessage = "Dear {$user_data['name']},\n" .
                    "Your Password has been successfully Changed.\n" .
                    "New Password: *{$newpassword}*\n\n" .
                    "Best Regards,\n" .
                    "_*{$site_data['brand']}.*_";
                    
                    send_sms_credentials($user_data['mobile'],$whamessage);
                    send_email($user_data['email'],"Password Changed",$emailmessage);

                    awal_alert_msg("Password Changed Successfully!", 'success', '');
                } else {
                    awal_alert_msg("No Any Changes!", 'info');
                }
            } else {
                awal_alert_msg("Confirm Password Does Not Match!", 'error');
            }
        } else {
            awal_alert_msg("Current Password is Incorrect!", 'error');
        }
    } else {
        awal_alert_msg("Please Fill All Valid Details!", 'error');
    }
}
?>

<div class="row">
    <!-- User Profile Update Form -->
    <div class="col-md-6 mb-2">
        <div class="card text-danger">
            <div class="card-header bg-primary text-white py-2">
                <div class="d-flex align-items-center">
                    <span class="mr-auto"><?= file_name() ?></span>
                </div>
            </div>
            <div class="p-3">
                <form class="row text-dark" method="POST" action="">
                    <div class="col-md-6 mb-3">
                        <label>Name</label>
                        <input type="text" class="form-control" placeholder="Enter Name" name="name" value="<?= $user_data['name'] ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Shop Name</label>
                        <input type="text" class="form-control" placeholder="Enter Shop Name" name="company" value="<?= $user_data['company'] ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Mobile Number</label>
                        <input type="number" class="form-control" placeholder="Enter Mobile Number" name="mobile" value="<?= $user_data['mobile'] ?>" onkeypress="if(this.value.length==10) return false;" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Email Address</label>
                        <input type="email" class="form-control" placeholder="Enter Email Address" name="email" value="<?= $user_data['email'] ?>" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>Aadhaar Number</label>
                        <input type="number" class="form-control" placeholder="Enter Aadhaar Number" name="aadhaar" value="<?= $user_data['aadhaar'] ?>" onkeypress="if(this.value.length==12) return false;" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label>PAN Number</label>
                        <input type="text" class="form-control" placeholder="Enter PAN Number" name="pan" value="<?= $user_data['pan'] ?>" onkeypress="if(this.value.length==10) return false;" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <select class="form-control" name="is_otp" required>
                            <option <?= $user_data['is_otp'] == "NO" ? 'selected' : '' ?> value="NO">2FA Authentication OFF</option>
                            <option <?= $user_data['is_otp'] == "YES" ? 'selected' : '' ?> value="YES">2FA Authentication ON</option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-3">
                        <button type="submit" class="btn btn-primary btn-block" name="userupdate">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Change Password Form -->
    <div class="col-md-6 mb-2">
        <div class="card text-danger">
            <div class="card-header bg-primary text-white py-2">
                <div class="d-flex align-items-center">
                    <span class="mr-auto">Change Password</span>
                </div>
            </div>
            <div class="p-3">
                <form class="row text-dark" method="POST" action="">
                    <div class="col-md-12 mb-3">
                        <label>Current Password</label>
                        <input type="password" class="form-control" placeholder="Enter Current Password" name="currentpassword" required>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label>New Password</label>
                        <input type="password" class="form-control" placeholder="Enter New Password" name="newpassword" required>
                    </div>
                    <div class="col-md-12 mb-3">
                        <label>Confirm Password</label>
                        <input type="password" class="form-control" placeholder="Enter Confirm Password" name="confirmpassword" required>
                    </div>
                    <div class="col-md-4 mb-3">
                        <button class="btn btn-primary btn-block" name="changepassword">Change Password</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
