<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <?php 
  $services = [
    ['link' => 'Pan_Apply_Correction', 'img' => 'subservice57.png', 'text' => 'NSDL Pan Apply/Correction ', 'bg' => '#e6f7ff', 'show' => $user_data['psa_active'] === "YES"],
    ['link' => 'panfind', 'img' => 'aadhartopan.png', 'text' => 'PAN Find', 'bg' => '#ffe6e6', 'show' => $user_data['pandfind_service'] === "YES"],
    ['link' => 'pan_Uid_Find', 'img' => 'panaadharlink.png', 'text' => 'PAN 2 Aadhar Find', 'bg' => '#fff5e6', 'show' => $user_data['pan2uid_find_service'] === "YES"],
    ['link' => 'PanDetails', 'img' => 'subservice57.png', 'text' => 'PAN Details', 'bg' => '#e6f7ff', 'show' => $user_data['pandetils_service'] === "YES"],
    ['link' => 'Pan_Card_Print', 'img' => 'pan_Print.png', 'text' => 'Pan Card Print', 'bg' => '#fff5e6', 'show' => $user_data['pan_print_service'] === "YES"],
    ['link' => 'aadhartomaskpan', 'img' => 'best-credit-card-2.png', 'text' => 'Aadhar to Mask Pan', 'bg' => '#f2e6ff', 'show' => $user_data['aadhar_to_maskpan_service'] === "YES"],
    ['link' => 'Pantomaskaadhaar', 'img' => 'maskaadhar.png', 'text' => 'PAN to Mask Aadhar', 'bg' => '#e6ffe6', 'show' => $user_data['pan_to_maskuid_service'] === "YES"],
    ['link' => 'PanuidLinkStatuscheck', 'img' => 'panaadharlink.png', 'text' => 'Pan Aadhar Link ðŸ”—', 'bg' => '#e6f7ff', 'show' => $user_data['aadhar_to_panLink_service'] === "YES"],
  ];
  
  foreach ($services as $service): 
    if (!$service['show']) {
      continue; 
    }
  ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
