<?php
require_once("../layouts/members/head.php");
?>
<div class="row">

<?php if(in_array($user_data['usertype'], ['Admin','White Label','Master Distributor','Distributor','Retailer'])){ ?>

  <div class="col-lg-12 col-md-12 col-12 mb-4 hand">
    <div class="card pmd-card hand">
      <div class="card-header bg-primary text-white py-2">
        <div class="d-flex align-items-center">
          <span class="mr-auto"><?=file_name()?></span>
        </div>
      </div>
      <div class="card-body p-0">
        <form class="row px-4 py-3" method="POST" action="">
          <div class="col-md-2 mb-2">
           <label>From Date</label>  
           <input type="date" name="fromDate" value="<?=date("Y-m-d")?>" class="form-control" required>
          </div>
          <div class="col-md-2 mb-2">
           <label>To Date</label>  
           <input type="date" name="toDate" value="<?=date("Y-m-d")?>" class="form-control" required>
          </div>
          <div class="col-md-2 mb-2">
           <label>Status</label>  
           <select name="status" class="form-control">
             <option value="">Select</option>
             <option value="Success">Success</option>
             <option value="Failed">Failed</option>
             <option value="Refund">Refund</option>
             <option value="Reversal">Reversal</option>
             <option value="Pending">Pending</option>
             <option value="Process">Process</option>
           </select>
          </div>
          <div class="col-md-4 mb-2">
           <label>Search</label>  
           <input type="text" name="searchInput" placeholder="Username / Order ID / Aadhaar / Etc" class="form-control">
          </div>
          <div class="col-md-2 mb-2">
           <label>&nbsp;</label>
           <button type="submit" name="search" class="btn btn-primary btn-block">Search</button>
          </div>
          
        </form>


       <div class="table-responsive scroll">
        <table class="table w-100" id="dataTable">
          <thead>
            <tr class="bg-secondary">
              <th class="d-none">SL No.</th>
              <th>Order ID</th>
              <th>Date Time</th>
              <th>Aadhaar</th>
              <th>Amount</th>
              <th>Opening</th>
              <th>Cr/Dr</th>
              <th>Closing</th>
              <th>PAN Number</th>
              <th>Status</th>
              <th>UserID</th>
            </tr>
          </thead>
          <tbody>

<?php
$fromDate = date("Y-m-d"); 
$toDate = date("Y-m-d");
$status = false;
$searchInput = false;
if(isset($_POST['search'])){
$fromDate = date("Y-m-d", strtotime($_POST['fromDate'])); 
$toDate = date("Y-m-d", strtotime($_POST['toDate']));
$status = safe_clean($_POST['status']);
$searchInput = safe_clean($_POST['searchInput']);
}

$condition = "date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' AND service='PANFIND'  AND type='Debit' ";


if(in_array($user_data['usertype'], ['Admin'])){
$condition .= '';
}else if(in_array($user_data['usertype'], ['White Label'])){
$condition .= " AND (user_id='".$user_data['user_id']."' || site_id='".$site_data['site_id']."' )"; 
}else{
$condition .= " AND user_id='".$user_data['user_id']."'";  
}


if(!empty($status)){
$condition .= " AND status ='".$status."'";    
}


if(!empty($searchInput)){
$condition .= " AND CONCAT(`username`,`order_id`,`account_number`,`txn_id`,`ref_id`,`service`) LIKE '%$searchInput%'";     
}


$response = db_fetch_all("reports", "$condition ORDER BY id DESC");
$sl=1;
foreach ($response as $key => $value) {
$value['date_time'] = date("d-M-Y h:i:s A",strtotime($value['date_time']));

if(in_array($value['status'],['Success'])){
$status = '<span class="badge badge-success"><span class="oi oi-circle-check pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Pending','Process'])){
$status = '<span class="badge badge-warning"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Failed','Refund'])){
$status = '<span class="badge badge-danger"><span class="fas fa-times-circle pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Reversal'])){
$status = '<span class="badge badge-info"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}
?>

            <tr>
              <td class="d-none"><?=$sl?></td>
              <td><?=$value['order_id']?></td>
              <td><?=$value['date_time']?></td>
              <td><?=$value['account_number']?></td>
              <td><i class="fas fa-inr fa-sm fa-fw"></i><?=$value['amount']?></td>
              <td><i class="fas fa-inr fa-sm fa-fw"></i><?=$value['old_balance']?></td>
              <td><i class="fas fa-inr fa-sm fa-fw"></i><?=$value['main_amount']?></td>
              <td><i class="fas fa-inr fa-sm fa-fw"></i><?=$value['new_balance']?></td>
              <td><?=$value['ref_id']?></td>
              <td><?=$status?></td>
              <td><?=$value['username']?></td>
            </tr>
<?php
$sl++;}
?>            
            
          </tbody>
        </table>
       </div>
      </div>
    </div>
  </div>
<?php 
}else{
require_once("404.php");
} 
?>
</div>
<?php
require_once("../layouts/members/foot.php");
data_table('#dataTable');
?>