<?php
require_once("../layouts/members/head.php");
?>

<div class="row">
<?php
if(in_array($user_data['usertype'], ['Admin'])){
?>   

   <div class="col-md-12 mb-2">
    <div class="card text-dark">
      <div class="card-header bg-primary text-white py-2">
        <div class="d-flex align-items-center">
          <span class="mr-auto">List Of Complaint</span>
        </div>
      </div>
      <div class="card-body p-0">
        <form class="row px-4 py-3" method="POST" action="">
          <div class="col-md-3 mb-2">
           <label>From Date</label>  
           <input type="date" name="fromDate" value="<?=date("Y-m-d")?>" class="form-control" required>
          </div>
          <div class="col-md-3 mb-2">
           <label>To Date</label>  
           <input type="date" name="toDate" value="<?=date("Y-m-d")?>" class="form-control" required>
          </div>
          <div class="col-md-3 mb-2">
           <label>Status</label>  
           <select name="status" class="form-control">
             <option value="">Select</option>
             <option value="Open">Open</option>
             <option value="Close">Close</option>
           </select>
          </div>
          <div class="col-md-3 mb-2">
           <label>&nbsp;</label>
           <button type="submit" name="search" class="btn btn-primary btn-block">Search</button>
          </div>
        </form>

       <div class="table-responsive scroll">
        <table class="table w-100" id="dataTable">
          <thead>
            <tr class="bg-secondary">
              <th class="d-none">SL No.</th>
              <th>Complaint ID</th>
              <th>Date Time</th>
              <th>Type</th>
              <th>Complaint</th>
              <th>Admin Remark</th>
              <th>Status</th>
              <th>UserID</th>
            </tr>
          </thead>
          <tbody>

<?php
$fromDate = date("Y-m-d"); 
$toDate = date("Y-m-d");
$status = false;
if(isset($_POST['search'])){
$fromDate = date("Y-m-d", strtotime($_POST['fromDate'])); 
$toDate = date("Y-m-d", strtotime($_POST['toDate']));
$status = safe_clean($_POST['status']);
}

$condition = "date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' ";


if(in_array($user_data['usertype'], ['Admin'])){
$condition .= '';
}else{
$condition .= " AND user_id='".$user_data['user_id']."'";  
}


if(!empty($status)){
$condition .= " AND status ='".$status."'";    
}

$response = db_fetch_all("complaints", "$condition ORDER BY complaint_id DESC");
$sl=1;
foreach ($response as $key => $value) {
$value['date_time'] = date("d-M-Y h:i:s A",strtotime($value['date_time']));

if(in_array($value['status'],['Close'])){
$status = '<span class="badge badge-success"><span class="oi oi-circle-check pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Open'])){
$status = '<span class="badge badge-danger"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}

?>

            <tr>
              <td class="d-none"><?=$sl?></td>
              <td>#<?=$value['complaint_id']?></td>
              <td><?=$value['date_time']?></td>
              <td><?=$value['complaint_type']?></td>
              <td><textarea class="form-control form-control-sm" readonly><?=$value['message']?></textarea></td>
              <td><textarea class="form-control form-control-sm" readonly><?=$value['remark']?></textarea></td>
              <td><?=$status?></td>
              <td><?=$value['username']?></td>
            </tr>
<?php
$sl++;}
?>            
            
          </tbody>
        </table>
       </div>

     </div>
    </div>
  </div>
<?php 
}
?>

</div>
<?php
require_once("../layouts/members/foot.php");
data_table('#dataTable');
?>