<?php
require_once("../layouts/members/head.php");
?>
<div class="row">

<?php
if (isset($_POST['addlink']) && $user_data['user_id'] > 0 && in_array($user_data['usertype'], ['Admin', 'White Label'])) {
    $name = real_escape_string($_POST['name']);
    $url = real_escape_string($_POST['url']);
    
    if (!empty($name) && !empty($url)) {
        $insData = [
            'site_id' => $site_data['site_id'],
            'user_id' => $user_data['user_id'],
            'name' => $name,
            'url' => $url
        ];
        
        if (db_insert("importantlink", $insData)) {
            awal_alert_msg("Add Link Successfully!", 'success', '');
        } else {
            awal_alert_msg("Server is Error!", 'info', '');
        }
    } else {
        awal_alert_msg("Please Fill All Valid Details!", 'error');
    }
}

if (isset($_POST['delete']) && $user_data['user_id'] > 0 && in_array($user_data['usertype'], ['Admin', 'White Label'])) {
    $id = real_escape_string($_POST['id']);
    
    if (!empty($id)) {
        $condition = "id='" . $id . "' and site_id='" . $site_data['site_id'] . "'";
        
        if (in_array($user_data['usertype'], ['Admin'])) {
            $condition = "id='" . $id . "'";
        }
        
        if (db_delete("importantlink", $condition)) {
            awal_alert_msg("Link Delete Successfully!", 'success', '');
        } else {
            awal_alert_msg("Server is Error!", 'info');
        }
    } else {
        awal_alert_msg("Error!", 'error');
    }
}
?>

<div class="col-md-12 mb-2">
    <div class="card text-dark">
        <div class="card-header bg-primary text-white py-2">
            <div class="d-flex align-items-center">
                <span class="mr-auto"><?= file_name() ?></span>
            </div>
        </div>

        <?php if (in_array($user_data['usertype'], ['Admin', 'White Label'])) { ?>
        <form class="row p-4" method="POST" action="">
            <div class="col-md-3 mb-3">
                <label>Name</label>
                <input type="text" class="form-control" placeholder="Enter Name" name="name" required>
            </div>
            <div class="col-md-6 mb-3">
                <label>URL</label>
                <input type="url" class="form-control" placeholder="Enter URL" name="url" required>
            </div>
            <div class="col-md-3 mb-3">
                <label>Add Link</label>
                <button type="submit" class="btn btn-primary btn-block" name="addlink">Submit</button>
            </div>
        </form>
        <?php } ?>

        <div class="table-responsive scroll">
            <table class="table w-100" id="dataTable">
                <thead>
                    <tr class="bg-secondary">
                        <th>SL No</th>
                        <th>Name</th>
                        <th>Link</th>
                        <?php if (in_array($user_data['usertype'], ['Admin', 'White Label'])) { ?>
                        <th>Action</th>
                        <?php } ?>
                    </tr>
                </thead>
                <tbody>

                  <?php
                  $response = db_fetch_all("importantlink", "site_id='" . $site_data['site_id'] . "' ORDER BY id DESC");
                  $sl = 1;
                  foreach ($response as $key => $value) {
                  ?>
                    <tr>
                        <td><?= $sl ?></td>
                        <td><?= $value['name'] ?></td>
                        <td><a href="<?= $value['url'] ?>" target="_blank"><i class="fas fa-link"></i> Open</a></td>
                        <?php if (in_array($user_data['usertype'], ['Admin', 'White Label'])) { ?>
                        <td>
                            <form method="POST" action="">
                                <input type="hidden" name="id" value="<?= $value['id'] ?>">
                                <button type="submit" class="btn btn-danger btn-xs mb-2" name="delete" title="Delete" onclick="return confirm('Are you sure?');">
                                    <i class="fas fa-trash"></i>
                                </button>
                            </form>
                        </td>
                        <?php } ?>
                    </tr>
                   <?php
                       $sl++;
                   }
                   ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

</div>
<?php
require_once("../layouts/members/foot.php");
data_table('#dataTable');
?>
