<?php
require_once("../layouts/members/head.php");
if ($user_data['familyid_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;

          if (isset($_POST['submit'])) {
              $familyidNumber = strtoupper($_POST['familyidNumber']);

              if (!empty($familyidNumber)) {
                  $amount = $user_data['familid_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'familyid' => $familyidNumber,
                          'order_id' => $order_id,
                      ];

                      $responseApi = familyIdVerification_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $printData = array(
                                  'NewFamilyID' => isset($response['NewFamilyID']) && !empty($response['NewFamilyID']) ? $response['NewFamilyID'] : $familyidNumber,
                                  'FamilyID' => isset($response['FamilyID']) && !empty($response['FamilyID']) ? $response['FamilyID'] : 'NA',
                                  'familyHeadName' => isset($response['familyHeadName']) && !empty($response['familyHeadName']) ? $response['familyHeadName'] : 'NA',
                                  'familyDName' => isset($response['familyDName']) && !empty($response['familyDName']) ? $response['familyDName'] : 'NA',
                                  'familyBName' => isset($response['familyBName']) && !empty($response['familyBName']) ? $response['familyBName'] : 'NA',
                                  'familyWName' => isset($response['familyWName']) && !empty($response['familyWName']) ? $response['familyWName'] : 'NA',
                                  'familyHouseNumber' => isset($response['familyHouseNumber']) && !empty($response['familyHouseNumber']) ? $response['familyHouseNumber'] : '0',
                                  'familyLandMark' => isset($response['familyLandMark']) && !empty($response['familyLandMark']) ? $response['familyLandMark'] : 'NA',
                                  'familyStreetNumber' => isset($response['familyStreetNumber']) && !empty($response['familyStreetNumber']) ? $response['familyStreetNumber'] : 'NA',
                                  'familyPinCode' => isset($response['FamilyPinCode']) && !empty($response['FamilyPinCode']) ? $response['FamilyPinCode'] : 'NA',
                                  'data' => $members = isset($response['data']) ? $response['data'] : [],
                                  'username'      => $user_data['username'],
                              );
                              $name = isset($response['familyHeadName']) && !empty($response['familyHeadName']) ? $response['familyHeadName'] : 'NA';

                               $Mremark = "Family ID: " . $familyidNumber;
                               $insData = [
                                   'order_id'      => $order_id,
                                   'username'      => $user_data['username'],
                                   'name'          => $name,
                                   'idNumber'      => $familyidNumber,
                                   'service'       => "FAMILYIDPDF",
                                   'date_time'     => current_timestamp(),
                                   'printData'     => base64_encode(str_replace("\\", "", json_encode($printData, JSON_UNESCAPED_UNICODE))),
                                   'photo'         => "",
                               ];

                               $insertIddata = db_insert("printRecords", $insData);
    
                               if ($insertIddata) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "FAMILYIDPDF",
                                  'type'          => "Debit",
                                  'account_number'=> $response['NewFamilyID'],
                                  'app_type'      => "FAMILYIDPDF",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['NewFamilyID'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Name {$response['familyHeadName']} FamilyID ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                 $fields = [
                                     'NewFamilyID' => 'Family ID',
                                     'familyHeadName' => 'Family Head Name',
                                     'familyLandMark' => 'Address',
                                     'familyPinCode' => 'PinCode',
                                 ];

                                 $whamessage = "Dear {$user_data['name']},\nYour Request for Family ID *{$familyidNumber}* Verification has been Complete.\n\n";

                                 foreach ($fields as $key => $label) {
                                     if (!empty($response[$key])) {
                                         $whamessage .= "*$label*: {$response[$key]}\n";
                                     }
                                 }
                                 $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                              awal_alert_msg("Data Fetch Successful from '.$Mremark.'.", 'success');
                                redirect('printRecord', 3000);
                            } else {
                                 awal_alert_msg("Saving Data Error!", 'error');
                             }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>FamilyID Number</label>
              <input type="text" name="familyidNumber" placeholder="Enter Family ID" maxlength="25" class="form-control" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['familid_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
        </div>
      </div>
    </div>
</div>

<!-- Modal to show fetched details -->
<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['FamilyID']) && !empty($response['FamilyID'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>FamilyID Number</label>
              <input type="text" value="<?= htmlspecialchars($response['NewFamilyID']) ?>" class="form-control" readonly>
            </div>
            <div class="col-md-6 mb-3">
              <label>Head Family</label>
              <input type="text" value="<?= htmlspecialchars($response['familyHeadName']) ?>" class="form-control" readonly>
              </div>
          </form>
        <?php } else { ?>
          <p>No details fetched yet. Submit FamilyID Verification.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['FamilyID']) && !empty($response['FamilyID'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have This Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
