<?php
require_once("../layouts/members/head.php");
$fromDate = date("Y-m-01");
$toDate = date("Y-m-d");
?>

<?php
if($main_site_data['popup_active']=="ON" && in_array($user_data['usertype'], ['White Label','Master Distributor','Distributor','Retailer'])){ ?>
  <style>
    .overlay {
      position: fixed;
      top: 0;
      left: 0;
      width: 100vw;
      height: 100vh;
      background-color: rgba(0, 0, 0, 0.8); 
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 9999;
    }
    .popup {
      background: #050000; 
      color: white;
      padding: 24px 32px;
      border-radius: 12px;
      position: relative;
      width: 400px;
      max-width: 90%;
      box-shadow: 0 8px 20px rgba(255, 255, 255, 0.1);
      animation: fadeIn 0.3s ease;
      text-align: center;
      font-family: Arial, sans-serif;
    }
    .popup .close-btn {
      position: absolute;
      top: 12px;
      right: 12px;
      background: none;
      border: none;
      font-size: 20px;
      cursor: pointer;
      color: white;
    }

    .popup .close-btn:hover {
      color: #ccc;
    }

    @keyframes fadeIn {
      from { opacity: 0; transform: scale(0.95); }
      to { opacity: 1; transform: scale(1); }
    }
  </style>
<div class="overlay" id="popupOverlay">
  <div class="popup">
    <button class="close-btn" onclick="closePopup()">✖</button>
    <h3>📌 Alert!</h3>
    <h6><?php echo isset($main_site_data['popupalert']) ? $main_site_data['popupalert'] : ''; ?></h6>
  </div>
</div>
<script>
  function closePopup() {
    document.getElementById("popupOverlay").style.display = "none";
  }
</script>
<?php } ?>
<?php if (isset($user_data['usertype']) && in_array($user_data['usertype'], ['White Label','Master Distributor','Distributor','Retailer'])) { ?>
<style>
  /* Floating WhatsApp Join Box */
  .whatsapp-join-box {
    position: fixed;
    bottom: 25px;
    right: 25px;
    background: linear-gradient(135deg, #25d366, #20c55c);
    color: #fff;
    border-radius: 14px;
    padding: 12px 16px;
    width: 240px;
    box-shadow: 0 6px 18px rgba(0, 0, 0, 0.25);
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    z-index: 9999;
    font-family: "Poppins", sans-serif;
    animation: slideUp 0.6s ease forwards;
  }

  .whatsapp-join-left {
    display: flex;
    gap: 10px;
    flex: 1;
  }

  .whatsapp-join-left img {
    width: 24px;
    height: 24px;
  }

  .whatsapp-join-content {
    flex: 1;
  }

  .whatsapp-join-content h4 {
    font-size: 14px;
    font-weight: 600;
    margin: 0;
  }

  .whatsapp-join-content p {
    font-size: 11.5px;
    margin: 2px 0 8px 0;
    opacity: 0.9;
  }

  .whatsapp-join-actions a {
    background: #fff;
    color: #25d366;
    border-radius: 20px;
    padding: 3px 12px;
    font-size: 12px;
    font-weight: 600;
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    transition: all 0.3s ease;
  }

  .whatsapp-join-actions a:hover {
    background: #e7f7ee;
    transform: scale(1.05);
  }

  .whatsapp-join-close {
    cursor: pointer;
    font-size: 16px;
    margin-left: 8px;
    opacity: 0.8;
    transition: opacity 0.2s ease;
  }

  .whatsapp-join-close:hover {
    opacity: 1;
  }

  @keyframes slideUp {
    from {
      opacity: 0;
      transform: translateY(40px) scale(0.95);
    }
    to {
      opacity: 1;
      transform: translateY(0) scale(1);
    }
  }
</style>

<!-- WhatsApp Join Popup -->
<div class="whatsapp-join-box" id="whatsappJoinBox">
  <div class="whatsapp-join-left">
    <img src="https://img.icons8.com/ios-filled/50/ffffff/whatsapp.png" alt="WhatsApp" />
    <div class="whatsapp-join-content">
      <h4>📢 Join Our Channel</h4>
      <p>Instant updates & offers</p>
      <div class="whatsapp-join-actions">
        <a href="https://wa.me/91<?php echo isset($main_site_data['mobile']) ? $main_site_data['mobile'] : '0000000000'; ?>" target="_blank">
          <img src="https://img.icons8.com/ios-filled/20/25d366/whatsapp.png" style="margin-right:5px;" /> Join
        </a>
      </div>
    </div>
  </div>
  <div class="whatsapp-join-close" onclick="closeWhatsAppBox()">×</div>
</div>

<script>
  function closeWhatsAppBox() {
    const box = document.getElementById('whatsappJoinBox');
    box.style.animation = 'fadeOut 0.4s forwards';
  }

  /* Smooth fade out animation */
  const style = document.createElement('style');
  style.innerHTML = `
    @keyframes fadeOut {
      from { opacity: 1; transform: translateY(0) scale(1); }
      to { opacity: 0; transform: translateY(40px) scale(0.9); }
    }
  `;
  document.head.appendChild(style);
</script>

<?php } ?>
<div class="row">
  <div class="col-md-12 mb-2">
      
<?php if (in_array($user_data['user_id'], ['1']) && in_array($user_data['usertype'], ['Admin'])) {
// Fetch update information
$updateApiUrl = "https://".p4pointsapi("cardprintApi_url")."/update/update_info.json";

function fetchUpdateInfo($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0');
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    $result = curl_exec($ch);
    curl_close($ch);
    return $result;
}

// Get update info
$updateInfoJson = fetchUpdateInfo($updateApiUrl);
$updateInfo = json_decode($updateInfoJson, true);

// Get current version from file
$versionFile = '../update/current_version.txt';
$currentVersion = file_exists($versionFile) ? trim(file_get_contents($versionFile)) : '1.0.0';

// Check if update is available
$updateAvailable = ($updateInfo && isset($updateInfo['version']) && $updateInfo['version'] !== $currentVersion);

// Check if button is clicked
$buttonText = "💰 Check API Balance";

if (isset($_POST['check_balance'])) {
    $responseApi = Api_balance_info_api_run();
    $response = json_decode($responseApi, true);

    if ($response['status'] === "100") {
        $buttonText = "💵 Balance: " . $response['balance']; // Replace button text
    } else {
        $buttonText = "❌ Error " . $response['error']; 
    }
}
?>

<?php if ($updateAvailable) { ?>
    <div id="updateBanner" style="background: #ffcc00; padding: 10px; text-align: center; font-weight: bold;">
        🚀 Update Available! (Version <?php echo $updateInfo['version']; ?>) - <a href="#" onclick="showUpdatePopup()">Click here to update</a>
    </div>
<?php } else { ?>
<style>
        .banner-container {
            display: flex;
            justify-content: space-between;
            align-items: center;
            background: #4CAF50;
            padding: 10px;
            color: white;
            font-weight: bold;
        }
        .button-container {
            display: flex;
            align-items: center;
        }
    </style>
<div class="banner-container">
    <span>✅ Your system is up to date! (Version <?php echo $currentVersion; ?>)</span>
    <div class="button-container">
        <form method="post">
            <button type="submit" name="check_balance" class="button"><?php echo $buttonText; ?></button>
        </form>
    </div>
</div>
<?php } ?>

<!-- Update Modal Popup -->
<div id="updateModal" style="display: none; position: fixed; top: 33%; left: 50%; transform: translate(-50%, -50%); background: black; color:white; padding: 20px; border: 2px solid #007bff; box-shadow: 0px 0px 10px #000; z-index: 1000; width: 400px;">
    <h2>Update Available</h2>
    <p><strong>Current Version:</strong> <?php echo $currentVersion; ?></p>
    <p><strong>New Version:</strong> <?php echo $updateInfo['version']; ?></p>
    <p><strong>Changelog:</strong></p>
    <p><?php echo nl2br($updateInfo['changelog']); ?></p>
    <button onclick="applyUpdate()">Update Now</button>
    <button onclick="hideUpdatePopup()">Cancel</button>
</div>

<script>
    function showUpdatePopup() {
        document.getElementById("updateModal").style.display = "block";
    }

    function hideUpdatePopup() {
        document.getElementById("updateModal").style.display = "none";
    }

    function applyUpdate() {
        if (confirm("Are you sure you want to apply the update?")) {
            fetch('../update/update.php', {
                method: 'POST',
                body: JSON.stringify({ 
                    update_url: "<?php echo $updateInfo['update_url']; ?>", 
                    version: "<?php echo $updateInfo['version']; ?>", 
                    extractPath: "<?php echo $updateInfo['extractPath']; ?>"
                }),
                headers: { 'Content-Type': 'application/json' }
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if (data.success) {
                    location.reload(); // Reload dashboard after update
                }
            })
            .catch(error => {
                alert("❌ Update Failed: " + error);
                console.error(error);
            });
        }
    }
</script>

<?php } ?>
    <span class="font-weight-bold">Hi, <?=$user_data['name']?></span>
  </div>



<?php if(in_array($user_data['usertype'], ['White Label','Master Distributor','Distributor','Retailer'])){ ?>

  <?php if(in_array($user_data['usertype'], ['Master Distributor','Distributor','Retailer'])){ ?>
  <div class="col-md-12 mb-2">
    <div class="card p-1 text-danger">
      <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
      <div class="carousel-inner">
      <div class="carousel-item active">
      <img class="d-block w-100" src="../layouts/members/assets/images/banner.png" style="height:120px">
      </div>
      <div class="carousel-item">
      <img class="d-block w-100" src="../layouts/members/assets/images/banner2.png" style="height:120px">
      </div>
      <div class="carousel-item">
      <img class="d-block w-100" src="../layouts/members/assets/images/banner3.png" style="height:120px">
      </div>
      </div>
      <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
      <span class="carousel-control-prev-icon" aria-hidden="true"></span>
      <span class="sr-only">Previous</span>
      </a>
      <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
      <span class="carousel-control-next-icon" aria-hidden="true"></span>
      <span class="sr-only">Next</span>
      </a>
      </div>
    </div>
  </div>
<?php } ?>
  <?php if(isset($user_data['recharge_active']) && $user_data['recharge_active'] == 'YES'){ ?>
  <!-- <div class="col-lg-2 col-md-6 col-6 mb-2 hand">-->
  <!--  <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='addmoney'">-->
  <!--    <div class="card-body">-->
  <!--          <div class="card-icon">-->
  <!--              <img src="../layouts/members/assets/images/ewallet.png" class="">-->
  <!--          </div>-->
  <!--          <hr class="hr">-->
  <!--          <p class="card-text">Add Wallet</p> -->
  <!--       </div>-->
  <!--  </div>-->
  <!--</div>-->
  <?php } ?>
  <?php if(isset($user_data['mobile_dth_recharge_services']) && $user_data['mobile_dth_recharge_services'] == 'YES'){ ?>
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='Recharge'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/recharge2.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Recharge Service</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['aadhar_service']) && $user_data['aadhar_service'] == 'YES'){ ?>
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='Uid_Hkb-Services'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/3dcard1.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Aadhaar Services</p> 
         </div>
    </div>
  </div>
  <?php } ?>
  <?php if(isset($user_data['pan_service']) && $user_data['pan_service'] == 'YES'){ ?>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='panService'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/subservice57.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Pan Card Services</p> 
         </div>
    </div>
  </div>
  <?php } ?>

  <?php if(isset($user_data['vehical_service']) && $user_data['vehical_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='VehicalService'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/Yamaha-Bike-PNG.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Vehical Services</p> 
         </div>
    </div>
  </div>
  <?php } ?>
  <?php if(isset($user_data['rationpdf_service']) && $user_data['rationpdf_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='RationService'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/ration1.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Ration Services</p> 
         </div>
    </div>
  </div>
  <?php } ?>
  <?php if(isset($user_data['voter_service']) && $user_data['voter_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='VoterService'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/voter.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Voter Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['farmer_services']) && $user_data['farmer_services'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='farmerService'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/farmerLogo.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Farmer Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['electricBill_services']) && $user_data['electricBill_services'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='electricBill_Service'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/electricBill.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">ElectriBill Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['rtps_service']) && $user_data['rtps_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='Rtps_Services'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/rtps.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">RTPS Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['janaadhar_service']) && $user_data['janaadhar_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='janAadhar_Services'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/janaadhar.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">JanAadhar Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  
  <?php if(isset($user_data['familyid_service']) && $user_data['familyid_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='familyID_Service'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/familyidLogo.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">FamilyID Services</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
  <?php if(isset($user_data['ll_service']) && $user_data['ll_service'] == 'YES'){ ?>
  
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='ll_exam_Request'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/test.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Learning Exam</p> 
         </div>
    </div>
  </div>
  <?php } ?> 
   <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card card-figure is-hoverable p-0 pmd-card text-center hand" onclick="location.href='Aditional_Services'">
      <div class="card-body">
            <div class="card-icon">
                <img src="../layouts/members/assets/images/pdf.png" class="">
            </div>
            <hr class="hr">
            <p class="card-text">Other Services</p> 
         </div>
    </div>
  </div>
  <hr>
 <?php if(in_array($user_data['usertype'], ['Master Distributor','Distributor'])){ ?>
<?php
$todaycommission = array();
$monthlycommission = array();
if(in_array($user_data['usertype'], ['White Label','Master Distributor','Distributor'])){
$totaldismasRetailer = db_count("members"," parent_uid='".$user_data['username']."'");
$totalDistributorr = db_count("members"," parent_uid='".$user_data['username']."' AND usertype='Distributor'");
$totalRetailer = db_count("members"," parent_uid='".$user_data['username']."' AND usertype='Retailer'");
$totalActivateRetailer = db_count("members"," parent_uid='".$user_data['username']."' AND status='Active'");
$totalBlockRetailer = db_count("members"," parent_uid='".$user_data['username']."' AND status !='Active'");

    
$downcommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Credit' AND operator='Commission' AND date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' "," sum(amount) as amount ");
$selfcommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='RECHARGE' AND date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," sum(amount-main_amount) as amount ");    
$todaycommission['amount'] = round($downcommission['amount'] + $selfcommission['amount'], 2);

$downcommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Credit' AND operator='Commission' AND date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' "," sum(amount) as amount ");
$selfcommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='RECHARGE' AND date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," sum(amount-main_amount) as amount ");    
$monthlycommission['amount'] = round($downcommission['amount'] + $selfcommission['amount'], 2);
   
}else{
$todaycommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='RECHARGE' AND date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," sum(amount-main_amount) as amount ");    
$monthlycommission = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='RECHARGE' AND date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," sum(amount-main_amount) as amount ");    
}

$todayutipan = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='UTIITSL' AND date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," count(id) as total , sum(main_amount) as amount ");    
$todaynsdlpan = db_fetch_array("reports"," user_id='".$user_data['user_id']."' AND status='Success' AND type='Debit' AND service='NSDL' AND date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59'  "," count(id) as total , sum(main_amount) as amount ");    
?>  

<!--Retailer Special DashBoard-->

<?php if(in_array($user_data['usertype'], ['Distributor'])){ ?>
  <div class="col-lg-4 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-danger text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalRetailer?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Retailer</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-4 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalActivateRetailer?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Active Users</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-4 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalBlockRetailer?></small></h4>
            </div>

            <hr class="hr bg-white">
            <p class="card-text">Inactive Users</p> 
         </div>
    </div>
  </div>
  <?php } ?>
  <?php if(in_array($user_data['usertype'], ['Master Distributor'])){ ?>
 
  <div class="col-lg-3 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-danger text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totaldismasRetailer?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Users</p> 
         </div>
    </div>
  </div>
  <div class="col-lg-3 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalDistributorr?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Distributor</p> 
         </div>
    </div>
  </div>
  <div class="col-lg-3 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-danger text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalRetailer?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Retailer</p> 
         </div>
    </div>
  </div>
  
  
  <div class="col-lg-3 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalBlockRetailer?></small></h4>
            </div>

            <hr class="hr bg-white">
            <p class="card-text">Inactive Users</p> 
         </div>
    </div>
  </div>
  <?php } ?>
  <?php } ?>
<?php
if(in_array($user_data['usertype'], ['Master Distributor','Distributor','Retailer'])){
?>
  <div class="col-lg-12 col-md-12 col-12 mb-4 hand mt-2">
    <div class="card pmd-card hand">
      <div class="card-header bg-primary text-white py-2">
        <div class="d-flex align-items-center">
          <span class="mr-auto">Last Account Activity</span>
          <a class="btn btn-secondary btn-sm" href="walletledger">View All</a>
        </div>
      </div>
      <div class="card-body p-0">
       <div class="table-responsive scroll">
        <table class="table w-100">
          <thead>
            <tr class="bg-secondary">
              <th>Service</th>
              <th>Type</th>
              <th>Amount</th>
              <th>Description</th>
              <th>Date Time</th>
              <th>Status</th>
              <th>UserID</th>
            </tr>
          </thead>
          <tbody>

<?php
$response = db_fetch_all("reports", "user_id='".$user_data['user_id']."' ORDER BY id DESC LIMIT 2");
foreach ($response as $key => $value) {
$value['date_time'] = date("d-M-Y h:i:s A",strtotime($value['date_time']));
if(in_array($value['type'],['Credit'])){
$type = '<span class="badge badge-subtle badge-success">Credit</span>';
}else if(in_array($value['type'],['Debit'])){
$type = '<span class="badge badge-subtle badge-danger">Debit</span>'; 
}


if(in_array($value['status'],['Success'])){
$status = '<span class="badge badge-success"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Pending','Process'])){
$status = '<span class="badge badge-warning"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Failed','Refund'])){
$status = '<span class="badge badge-danger"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}else if(in_array($value['status'],['Reversal'])){
$status = '<span class="badge badge-info"><span class="oi oi-media-record pulse mr-1"></span>'.$value['status'].'</span>';
}

?>

            <tr>
              <td><?=$value['service']?></td>
              <td><?=$type?></td>
              <td><i class="fas fa-inr fa-sm fa-fw"></i><?=$value['main_amount']?></td>
              <td><?=$value['description']?></td>
              <td><?=$value['date_time']?></td>
              <td><?=$status?></td>
              <td><?=$value['username']?></td>
            </tr>
<?php
}
?>            
            
          </tbody>
        </table>
       </div>
      </div>
    </div>
  </div>
<?php } ?> 
<?php } ?>


<?php if (in_array($user_data['user_id'], ['1']) && in_array($user_data['usertype'], ['Admin'])) { ?>  

<?php
$fromDate = date("Y-m-01"); 
$toDate = date("Y-m-d");

$totaladmininActiveUsers = db_count("members","status !='Active'");
$totaladminr = db_count("members","usertype='Admin'");

$opencomplaints  = db_fetch_array("complaints", " status='Open' "," count(complaint_id) as total_reports ");

$totalmember = db_fetch_array("members"," usertype!='Admin' "," count(user_id) as total_member, sum(balance) as total_balance ");
$totalretailer = db_fetch_array("members"," usertype='Retailer' "," count(user_id) as total_member, sum(balance) as total_balance ");
$totaldistributor = db_fetch_array("members"," usertype='Distributor' "," count(user_id) as total_member, sum(balance) as total_balance ");
$totalmaster = db_fetch_array("members"," usertype='Master Distributor' "," count(user_id) as total_member, sum(balance) as total_balance ");

$condition = "date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' AND status='Success' AND service='WALLET' AND type='Credit' ";
$rechargetoday = db_fetch_array("reports",$condition," count(id) as total_reports, sum(amount) as total_amount ");

$condition = "date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' AND status='Success' AND service='WALLET' AND type='Credit' ";
$rechargehistory = db_fetch_array("reports",$condition," count(id) as total_reports, sum(amount) as total_amount ");

$condition = "date_time>='".$fromDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' AND status='Success' AND type='Debit'";
$transactionMonthly = db_fetch_array("reports",$condition," count(id) as total_reports, sum(amount) as total_amount ");

$condition = "date_time>='".$toDate." 00:00:00' AND date_time<='".$toDate." 23:59:59' AND status='Success' AND type='Debit'";
$transactionToday = db_fetch_array("reports",$condition," count(id) as total_reports, sum(amount) as total_amount ");

$services = [
    'NSDL_PAN' => 'NSDLPanApplyCorrectionHistory',
    'RECHARGE' => 'RechargemobileDthHistory',
    'AADHAAR FINGERPRINT' => 'AadharfingerprintHistory',
    'AADHAAR NUMBER VERIFY' => 'AadharnumberVerifyHistory',
    'CHALLAN' => 'ChallanHistory',
    'DL PDF' => 'DlPdfHistory',
    'ENROLLMENT STATUS CHECK' => 'EnrollmentStatusHistory',
    'RATIONPDF' => 'RationPdfHistory',
    'PANFIND' => 'PanFindHistory',
    'PANDETAILS' => 'PanDetailsHistory',
    'PAN UID LINK STATUS' => 'PanuidLinkstatusHistory',
    'PAN TO MASK UID' => 'PanmaskuidHistory',
    'IFSCVERIFY' => 'IfscverifyHistory',
    'MOBILEVERIFY' => 'MobileVerifyHistory',
    'PINCODEVERIFY' => 'PincodeVerifyHistory',
    'VEHICALRCPDF' => 'VehicalRCPdfHistory',
    'VOTERADVANCE' => 'VoterAdvanceHistory',
    'VOTERPDF' => 'VoterPDFHistory',
    'VOTERMOBILELINK' => 'VoterMobileLinkHistory',
    'Pmjay_Verification' => 'PmjaycardHistory',
    'LL REQUEST' => 'LLexamHistory',
    'e_Sharm_Verification' => 'eshramcardHistory',
    'UID_TO_INSTANT_DETAILS' => 'UID_TO_INSTANT_DETAILSHistory',
    'RATION2_UID' => 'RATION2_UIDHistory',
    'Agri_Farmer_Certificate' => 'AgriFarmerPDFHistory',
    'Agri_Farmer_Status' => 'AgriFarmerStatusHistory',
    'AADHAR_OTP_VERIFICATION' => 'AADHAR_OTP_VERIFICATIONHistory',
];

foreach ($services as $service => $variableName) {
    $condition = "date_time>='" . $toDate . " 00:00:00' AND date_time<='" . $toDate . " 23:59:59' AND status='Success' AND service='$service' AND type='Debit' ";
    $$variableName = db_fetch_array("reports", $condition, " count(id) as total_reports, sum(amount) as total_amount ");
}

?>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalmember['total_member']?> <small>₹<?= isset($totalmember['total_balance']) ? round($totalmember['total_balance'], 2) : '0.00' ?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Users</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><small> <i class="fas fa-times-circle" style="color: black;"></i></small> : <?=$totaladmininActiveUsers?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Inactive Users</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totaladminr?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Verified Admin <i class="fas fa-check-circle" style="color: black;"></i></p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalmaster['total_member']?> <small>₹<?= isset($totalmaster['total_balance']) ? round($totalmaster['total_balance'], 2) : '0.00' ?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Master Distributor</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totaldistributor['total_member']?> <small>₹<?= isset($totaldistributor['total_balance']) ? round($totaldistributor['total_balance'], 2) : '0.00' ?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Distributor</p> 
         </div>
    </div>
  </div>


  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$totalretailer['total_member']?> <small>₹<?= isset($totalretailer['total_balance']) ? round($totalretailer['total_balance'], 2) : '0.00' ?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Total Retailer</p> 
         </div>
    </div>
  </div>
 
 <!--Transaction for admin all service Powered By HKB WEB-->
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='addmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><span class="fas fa-users"></span></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Add New Member</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='opencomplaint'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$opencomplaints['total_reports']?></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Open Complaints</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='#'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$transactionMonthly['total_reports']?> <small>₹<?=$transactionMonthly['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Monthly Transactions</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='#'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$transactionToday['total_reports']?> <small>₹<?=$transactionToday['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Transactions</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='#'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$rechargehistory['total_reports']?> <small>₹<?=$rechargehistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Monthly Recharge</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-primary text-white hand" onclick="location.href='#'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$rechargetoday['total_reports']?> <small>₹<?=$rechargetoday['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Recharge</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='walletledger'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$RechargemobileDthHistory['total_reports']?> <small>₹<?=$RechargemobileDthHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Mobile/DTH Recharge</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='walletledger'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$NSDLPanApplyCorrectionHistory['total_reports']?> <small>₹<?=$NSDLPanApplyCorrectionHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today NSDL PAN</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$AadharfingerprintHistory['total_reports']?> <small>₹<?=$AadharfingerprintHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today UID Fingerprint</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$AadharnumberVerifyHistory['total_reports']?> <small>₹<?=$AadharnumberVerifyHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today UID No. Verify</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$EnrollmentStatusHistory['total_reports']?> <small>₹<?=$EnrollmentStatusHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Enroll Status</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$ChallanHistory['total_reports']?> <small>₹<?=$ChallanHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Challan Verify</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$DlPdfHistory['total_reports']?> <small>₹<?=$DlPdfHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Driving Licence</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-success text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$VehicalRCPdfHistory['total_reports']?> <small>₹<?=$VehicalRCPdfHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Vehical RC PDF</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$RationPdfHistory['total_reports']?> <small>₹<?=$RationPdfHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Ration PDF</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PanFindHistory['total_reports']?> <small>₹<?=$PanFindHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today UID Pan FIND</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PanDetailsHistory['total_reports']?> <small>₹<?=$PanDetailsHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Pan details</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PanuidLinkstatusHistory['total_reports']?> <small>₹<?=$PanuidLinkstatusHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Pan-UID Link-S</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PanmaskuidHistory['total_reports']?> <small>₹<?=$PanmaskuidHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Pan Mask UID</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-yellow text-black hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$IfscverifyHistory['total_reports']?> <small>₹<?=$IfscverifyHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today IFSC Verify</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$MobileVerifyHistory['total_reports']?> <small>₹<?=$MobileVerifyHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Mobile Verify</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PincodeVerifyHistory['total_reports']?> <small>₹<?=$PincodeVerifyHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Pincode Verify</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$VoterMobileLinkHistory['total_reports']?> <small>₹<?=$VoterMobileLinkHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Voter Mobile Link</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$VoterAdvanceHistory['total_reports']?> <small>₹<?=$VoterAdvanceHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Voter Advance</p> 
         </div>
    </div>
  </div>

  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$VoterPDFHistory['total_reports']?> <small>₹<?=$VoterPDFHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Voter PDF</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-purple text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$PmjaycardHistory['total_reports']?> <small>₹<?=$PmjaycardHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Ayushman</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$LLexamHistory['total_reports']?> <small>₹<?=$LLexamHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today LL Exam</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$eshramcardHistory['total_reports']?> <small>₹<?=$eshramcardHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today e-Shram Card</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$UID_TO_INSTANT_DETAILSHistory['total_reports']?> <small>₹<?=$UID_TO_INSTANT_DETAILSHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today UID 2 Details</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$RATION2_UIDHistory['total_reports']?> <small>₹<?=$RATION2_UIDHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Ration 2 UID</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$AgriFarmerPDFHistory['total_reports']?> <small>₹<?=$AgriFarmerPDFHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Agri Farmer PDF</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$AgriFarmerStatusHistory['total_reports']?> <small>₹<?=$AgriFarmerStatusHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Agri Farmer Status</p> 
         </div>
    </div>
  </div>
  
  <div class="col-lg-2 col-md-6 col-6 mb-2 hand">
    <div class="card pmd-card card-figure is-hoverable p-0 text-center bg-red text-white hand" onclick="location.href='listofmember'">
      <div class="card-body">
            <div class="card-icon">
                <h4><?=$AADHAR_OTP_VERIFICATIONHistory['total_reports']?> <small>₹<?=$AADHAR_OTP_VERIFICATIONHistory['total_amount']?></small></h4>
            </div>
            <hr class="hr bg-white">
            <p class="card-text">Today Aadhar OTP PDF</p> 
         </div>
    </div>
  </div>
  
<?php } ?>
</div>
<?php
require_once("../layouts/members/foot.php");
?>