<?php
require_once("../config/session.php");
require_once("../config/function.php");
$main_site_data = main_site_data();
$site_data = site_data();
?>
<?php if(isset($site_data['self_registertion']) && $site_data['self_registertion'] == 'active'){ ?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title> Create an Account | <?=$site_data['brand']?></title>
    <meta name="author" content="NEW WEB">
    <meta property="og:locale" content="en_US">
    <meta name="description" content="Responsive admin theme build on top of Bootstrap 4">
    <!-- Favicons -->
    <link rel="icon" href="<?=$site_data['logo']?>" type="image/*" sizes="16x16">
    <meta name="theme-color" content="#3063A0">
    <link href="https://fonts.googleapis.com/css?family=Fira+Sans:400,500,600" rel="stylesheet"><!-- End Google font -->
    <!-- BEGIN PLUGINS STYLES -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/open-iconic/1.1.1/font/css/open-iconic-bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- BEGIN THEME STYLES -->
    <link rel="stylesheet" href="../layouts/members/assets/stylesheets/theme.min.css" data-skin="default">
    <link rel="stylesheet" href="../layouts/members/assets/stylesheets/theme-dark.min.css" data-skin="dark">
    <link rel="stylesheet" href="../layouts/members/assets/stylesheets/custom.css">
<script>
var skin = localStorage.getItem('skin') || 'default';
var disabledSkinStylesheet = document.querySelector('link[data-skin]:not([data-skin="' + skin + '"])');
// Disable unused skin immediately
disabledSkinStylesheet.setAttribute('rel', '');
disabledSkinStylesheet.setAttribute('disabled', true);
</script>

<style>
.logo {
	max-width: 100%;
	height: 100px;
}
</style>

  </head>
  <body>
    <main class="auth">
      <header id="auth-header" class="auth-header pt-5" style="background-image: url(../layouts/members/assets/images/illustration/img-1.png);">
        <h1>
          <img src="<?=$site_data['logo']?>" class="logo">	
        </h1>
        <p>Create Account</p>
      </header>
      <form class="auth-form row py-4" method="POST" action="" style="max-width:90%">
<?php
if(isset($_POST['createaccount'])){
$name = real_escape_string($_POST['name']);
$password = real_escape_string($_POST['password']);
$company = real_escape_string($_POST['company']);
$mobile = is_valid_mobile($_POST['mobile']);
$email = is_valid_email($_POST['email']);
$aadhaar = is_valid_aadhaar($_POST['aadhaar'] ?? '000000000000');
$pan = is_valid_pan($_POST['pan'] ?? '0000000000');
$usertype = is_valid_usertype($_POST['usertype']);

if(!empty($name) && !empty($company) && !empty($mobile) && !empty($email) && !empty($aadhaar) && !empty($pan) && !empty($usertype)){

if(in_array($usertype, ['Master Distributor','Distributor','Retailer'])){

$username = get_username($mobile);
$condition = " username='".$username."' || mobile='".$mobile."' ";
$old_member = db_fetch_all("members",$condition);
if(count($old_member)==0){

// $password = generateNumericOTP(6);
$insData = array();
$insData['site_id'] = $site_data['site_id'];
$insData['username'] = $username;
$insData['password'] = $password;
$insData['is_otp'] = "NO";
$insData['usertype'] = $usertype;
$insData['parent_id'] = $site_data['user_id'];
$insData['parent_uid'] = $site_data['username'];
$insData['name'] = $name;
$insData['company'] = $company;
$insData['mobile'] = $mobile;
$insData['email'] = $email;
$insData['aadhaar'] = $aadhaar;
$insData['pan'] = $pan;
$insData['balance'] = 0;
$insData['plan_id'] = "1";
$insData['created_at'] = current_timestamp();
$insData['remark'] = "";
$insData['status'] = "Unpaid";
$insertId = db_insert("members", $insData);
if($insertId){
$token = aes_encrypt($insertId,$site_data['user_id']);
$activationLink = "{$site_data['protocol']}{$site_data['baseurl']}/members/selfactivation?token=$token";
$message = "Dear {$insData['name']}, Please activate your account by clicking the link below $activationLink";    
send_sms_credentials($insData['mobile'],$message);
send_email($insData['email'],"Account Activation",$message); 
redirect($activationLink,0);
die("Please do not refresh this page...");
}else{
awal_alert_msg("Server is Error!",'info');  
}

}else{
awal_alert_msg("Username OR Mobile Already Exists!",'error');
}

}else{
awal_alert_msg("UserType Not Access!",'error');
}

}else{
awal_alert_msg("Please Fill All Valid Details!",'error');
}

}
?>

        <div class="col-md-3 mb-3">
          <label>Name</label>
          <input type="text" class="form-control" placeholder="Enter Name" name="name" required>
        </div>
        <div class="col-md-3 mb-3">
          <label>Shop Name</label>
          <input type="text" class="form-control" placeholder="Enter Shop Name" name="company" required>
        </div>
        <div class="col-md-3 mb-3">
          <label>User Type</label>
          <select class="form-control" name="usertype" required>
                <option value="">Select</option>
                <option value="Retailer">Retailer</option>
                <option value="Distributor">Distributor</option>
                <option value="Master Distributor">Master Distributor</option>
            </select>
        </div>
        <div class="col-md-3 mb-3">
          <label>Mobile Number</label>
          <input type="number" class="form-control" placeholder="Enter Mobile Number" name="mobile" onkeypress="if(this.value.length==10) return false;" required>
        </div>
        <div class="col-md-3 mb-3">
          <label>Password</label>
          <input type="text" class="form-control" placeholder="Abcr@1234" name="password" onkeypress="if(this.value.length==25) return false;" required>
        </div>
        <div class="col-md-3 mb-3">
          <label>Email Address</label>
          <input type="emial" class="form-control" placeholder="Enter Email Address" name="email" required>
        </div>
        <!--<div class="col-md-3 mb-3">-->
        <!--  <label>Aadhaar Number</label>-->
        <!--  <input type="number" class="form-control" placeholder="Enter Aadhaar Number" name="aadhaar" onkeypress="if(this.value.length==12) return false;" required>-->
        <!--</div>-->
        <!--<div class="col-md-3 mb-3">-->
        <!--  <label>PAN Number</label>-->
        <!--  <input type="text" class="form-control" placeholder="Enter PAN Number" name="pan" onkeypress="if(this.value.length==10) return false;" required>-->
        <!--</div>-->
        
        <div class="col-md-3 mb-3">
          <label>Create Account</label>
          <button type="submit" class="btn btn-primary btn-block" name="createaccount">Submit</button>
        </div>
      </form>
      <div class="text-center mt-4 mb-5">
        <a href="login" class="link">Back To Login</a> 
      </div>

      <!-- copyright -->
      <footer class="auth-footer">Copyright © <?=date("Y")?> All Rights Reserved.</footer>
    </main><!-- /.auth -->
    <!-- BEGIN BASE JS -->
    <script src="../layouts/members/assets/vendor/jquery/jquery.min.js"></script>
    <script src="../layouts/members/assets/vendor/popper.js/umd/popper.min.js"></script>
    <script src="../layouts/members/assets/vendor/bootstrap/js/bootstrap.min.js"></script>
  </body>
</html>

<?php 
}else{
require_once("404.php");
} 
?>