<?php
require_once("../layouts/members/head.php");
if ($user_data['chassis2rc_services'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $chassisNumber = $_POST['chassisNumber'] ?? '';

              if (!empty($chassisNumber)) {
                  $amount = $user_data['chassis2rc_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'chassisNumber' => $chassisNumber,
                      ];

                      $responseApi = chassis2Rc_find_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "CHASSIS TO RC FIND",
                                  'type'          => "Debit",
                                  'account_number'=> $response['regNo'],
                                  'app_type'      => "CHASSIS TO RC FIND",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['regNo'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Rc Number {$response['regNo']} Chassis ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'regNo' => 'Vehical No',
                                      'owner' => 'Name',
                                      'chassis' => 'Chassis',
                                      'engine' => 'Engine',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Chassis *{$licenceNumber}* To RC Verification has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && isset($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }

                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Chassis Number</label>
              <input type="text" name="chassisNumber" placeholder="MA1UJ2ZNTP2M1****" maxlength="25" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==25) return false;"required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['chassis2rc_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- Display Datatable Section -->
    <?php if (isset($response['status']) && $response['status'] == '100') {  ?>
<div class="col-md-8 mb-2">
  <div class="card text-danger">
    <div class="card-header bg-danger text-white py-2">
      <span class="mr-auto">Details Searching Complete Chassis No: <strong><?= $licenceNumber ?? 'N/A'; ?></strong></span>
    </div>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <tbody>
          <?php if (!empty($response['regNo'])): ?>
          <tr>
            <td><strong>RC Number</strong></td>
            <td><?= htmlspecialchars($response['regNo']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['owner'])): ?>
          <tr>
            <td><strong>Owner</strong></td>
            <td><?= htmlspecialchars($response['owner']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['chassis'])): ?>
          <tr>
            <td><strong>Chassis</strong></td>
            <td><?= htmlspecialchars($response['chassis']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['engine'])): ?>
          <tr>
            <td><strong>Engine</strong></td>
            <td><?= htmlspecialchars($response['engine']); ?></td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any Vehical Service Active!', 'info', 'dashboard');
}

require_once("../layouts/members/foot.php");
?>
