<?php
require_once("../layouts/members/head.php");
 if ($user_data['voter_advance_Service'] == "YES") { 
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
  $getresult = false;
  $getresults = true;
?>
<?php
if (isset($_POST['submit'])) {
    $getresult = true;
    $getresults = false;
    $voterNumber = $_POST['voterNumber'] ?? '';
    if (!empty($voterNumber)) {
    $order_id = order_txn_id();
    $amount = $user_data['voter_advance_fee']/2;
    $old_balance = $user_data['balance'];
    $new_balance = $old_balance - $amount;
    
if ($old_balance >= $amount) {
    
$request = [
    'voterNumber' => $voterNumber,
    'order_id' => $order_id
];

 $responseApi = voterAdvance_api_run($request);
 $errorApi = json_decode($responseApi, true) ?? '';
 $response = json_decode($responseApi, true)['response']['docs'][0] ?? '';

if (isset($response['statusCode']) && $response['statusCode'] == '200') {
    $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

    if ($updateSuccess) {
        $insData = [
            'site_id'       => $site_data['site_id'],
            'user_id'       => $user_data['user_id'],
            'username'      => $user_data['username'],
            'name'          => $user_data['name'],
            'operator'      => $user_data['usertype'],
            'parent_id'     => $user_data['parent_id'],
            'order_id'      => $order_id,
            'service'       => "VOTERADVANCE",
            'type'          => "Debit",
            'account_number'=> $response['epic_no'],
            'app_type'      => "VOTERADVANCE",
            'amount'        => $amount,
            'main_amount'   => $amount,
            'old_balance'   => $old_balance,
            'new_balance'   => $new_balance,
            'txn_id'        => $order_id,
            'ref_id'        => $response['name'],
            'description'   => "Rs.{$amount} Has Been Debit From Wallet for Voter {$response['epic_no']} for Voter Card Print Name: ",
            'date_time'     => current_timestamp(),
            'status'        => "Success"
        ];

        $insertId = db_insert("reports", $insData);
        if ($insertId) {
           $fields = [
               'name' => 'Name',
               'rln_name' => 'Father/Husband',
               'epic_no' => 'Epic No',
               'gender' => 'Gender',
               'state' => 'State',
               'part_name' => 'Address',
           ];

           $whamessage = "Dear {$user_data['name']},\nYour Request for Voter *{$response['epic_no']}* Details For Card Print has been Complete.\n\n";

           foreach ($fields as $key => $label) {
               if (!empty($response[$key])) {
                   $whamessage .= "*$label*: {$response[$key]}\n";
               }
           }
           $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
            send_sms($user_data['mobile'],$whamessage);
          //   awal_alert_msg("Voter Details Fetched Successfully!", 'success');
        } else {
            awal_alert_msg("Insert Server Error!", 'error');
        }
    } else {
        awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
    }
} else {
    awal_alert_msg($errorApi['error'] ?? $response['error'] ?? 'Server Down', 'error');
}
}else {
   alert_msg("Balance Low Please Recharge!", 'danger');
}
}else {
   alert_msg("Please Fill All Valid Details!", 'danger');
}
}

if (isset($_POST['savedata'])) {
    $order_id = order_txn_id();
    $amount = $user_data['voter_advance_fee']/2;
    $old_balance = $user_data['balance'];
    $new_balance = $old_balance - $amount;
    $voterNumber = strtoupper($_POST['voterNumber']);
    $votername = strtoupper(trim($_POST['name']));
if ($old_balance >= $amount) {
    
$base64Image = null;
if (isset($_FILES['imageInput']) && $_FILES['imageInput']['error'] === UPLOAD_ERR_OK) {
    $imageFile = $_FILES['imageInput']['tmp_name'];
    $imageSize = $_FILES['imageInput']['size'];
    $imageType = mime_content_type($imageFile);
    $allowedTypes = ['image/jpeg', 'image/png', 'image/jpg', 'image/webp'];
    if ($imageSize <= 102400 && in_array($imageType, $allowedTypes)) {
        $imageData = file_get_contents($imageFile);
        $base64Image = 'data:' . $imageType . ';base64,' . base64_encode($imageData);

    $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");
    if ($updateSuccess) {
     $insData = [
         'site_id'       => $site_data['site_id'],
         'user_id'       => $user_data['user_id'],
         'username'      => $user_data['username'],
         'name'          => $user_data['name'],
         'operator'      => $user_data['usertype'],
         'parent_id'     => $user_data['parent_id'],
         'order_id'      => $order_id,
         'service'       => "VOTER CARD PRINT",
         'type'          => "Debit",
         'account_number'=> $voterNumber,
         'app_type'      => "VOTER CARD PRINT",
         'amount'        => $amount,
         'main_amount'   => $amount,
         'old_balance'   => $old_balance,
         'new_balance'   => $new_balance,
         'txn_id'        => $order_id,
         'ref_id'        => $voterNumber,
         'description'   => "Rs.{$amount} Has Been Debit From Wallet for Name {$votername} for VOTER CARD PRINT By epic ",
         'date_time'     => current_timestamp(),
         'status'        => "Success"
     ];

     $insertIds = db_insert("reports", $insData);
     if ($insertIds) {
         //successful insert in records
      } else {
          awal_alert_msg("Insert Server Error!", 'error');
      }
     
$printData = array(
    'votername' => strtoupper(trim($_POST['name'])),
    'namelocal' => trim($_POST['namelocal']),
    'dob' => trim($_POST['dobhkb']),
    'dobinlocal' => trim($_POST['birthtithilocal']),
    'gender' => trim($_POST['gender']),
    'genderlocal' => trim($_POST['genderlocal']),
    'sexlocal' => trim($_POST['sexlocal']),
    'spousename' => trim($_POST['spousename']),
    'spousenamelocal' => trim($_POST['spousenamelocal']),
    'fathername' => strtoupper(trim($_POST['fathername'])),
    'fathernamelocal' => trim($_POST['fathernamelocal']),
    'epicno' => trim($_POST['voterNumber']),
    'fulladdress' => trim($_POST['address']),
    'localaddress' => trim($_POST['addresslocal']),
    'pata' => trim($_POST['patalocal']),
    'kaname' => trim($_POST['kanamelocal']),
    'policestation' => '',
    'tahshil' => trim($_POST['tahshil']),
    'assconnonm' => trim($_POST['assemblyconnameno']),
    'assconnonmlocal' => trim($_POST['assemblyconnamenolocal']),
    'assconnameno' => 'Assembly Constituency No. & Name',
    'assconnamenolocal' => trim($_POST['assconnamenolocal']),
    'partno' => trim($_POST['partno']),
    'partname' => trim($_POST['partname']),
    'partnamelocal' => trim($_POST['partnamelocal']),
    'partnoandname' => 'Part No and Name',
    'partnoandnamelocal' => trim($_POST['partnoandnamelocal']),
    'state' => trim($_POST['state']),
    'locallanguage' => trim($_POST['language']),
    'sign' => '',
    'signlocal' => trim($_POST['signlocal']),
    'imagepathoriginal' => $base64Image,
    'date_time' => current_timestamp(),
    'username' => $user_data['username'],
);

    $Mremark = 'Name: ' . $votername . " - Voter Number: " . $voterNumber;
    $insData = [
        'order_id'      => $order_id,
        'username'      => $user_data['username'],
        'name'          => $votername,
        'idNumber'      => $voterNumber,
        'service'       => "VOTER PRINT",
        'date_time'     => current_timestamp(),
        'printData'     => base64_encode(str_replace("\\", "", json_encode($printData, JSON_UNESCAPED_UNICODE))),
        'photo'         => $base64Image,
    ];

    $insertId = db_insert("printRecords", $insData);
    
    if ($insertId) {
         awal_alert_msg("Voter Download Successful from '.$Mremark.'.", 'success');
        redirect('printRecord', 3000);
     } else {
         awal_alert_msg("Saving Data Error!", 'error');
     }
   } else {
       awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
   }
  } else {
        alert_msg("Invalid image file. Please upload a JPG, JPEG, or PNG file under 100KB.", 'danger');
  }
 } else {
    alert_msg("No valid image file uploaded. Please try again.", 'danger');
 }

} else {
   awal_alert_msg("Insufficient Wallet Balance!", 'error');
} 

}
?>

    <div class="col-md-4 mb-2 <?= isset($getresults) && $getresults ? '' : 'd-none' ?>">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Voter Number</label>
               <input type="text" class="form-control" id="voterNumber" name="voterNumber" maxlength="20" placeholder="BPL****605" autocomplete="off" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo isset($user_data['voter_advance_fee']) ? $user_data['voter_advance_fee'] : 0; ?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    
<div class="container-xxl flex-grow-1 container-p-y <?= isset($getresult) && $getresult ? '' : 'd-none' ?>">
    <div class="row">
        <div class="col-lg-5">
            <div class="card border">
                <div class="card-header text-white bg-primary">
                    <h6 class="mb-0">Voter Details in English</h6>
                </div><form method="post" action="" id="myForm" enctype="multipart/form-data">
                <div class="card-body">
                        <div class="mb-3">
                            <label for="voterNumber" class="form-label">Voter Number:</label>
                            <input type="text" class="form-control" id="voterNumber" name="voterNumber" maxlength="20" value="<?php echo isset($response['epic_no']) ? strtoupper($response['epic_no']) : ''; ?>" placeholder="BPL****605" autocomplete="off" required>
                        </div>
                        <div class="mb-3">
                            <label for="name" class="form-label">Full Name:</label>
                            <input type="text" class="form-control" name="name" id="name" value="<?php echo isset($response['name']) ? ucwords($response['name']) : ''; ?>" placeholder="Enter Name" autocomplete="off" required>
                        </div>
                        <div class="mb-3">
                            <label for="fathername" class="form-label">Father / Husband Name:</label>
                            <input type="text" class="form-control" name="fathername" id="fathername" value="<?php echo isset($response['rln_name']) ? ucwords($response['rln_name']) : ''; ?>" placeholder="Enter Father / Husband Name" autocomplete="off" required>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="gender" class="form-label">Select Gender:</label>
                                <select class="form-control" id="gender" name="gender" required>
                                    <option value="">Select Gender</option>
                                    <option value="Male" <?php echo (isset($response['gender']) && $response['gender'] == 'M') ? 'selected' : ''; ?>>Male</option>
                                    <option value="Female" <?php echo (isset($response['gender']) && $response['gender'] == 'F') ? 'selected' : ''; ?>>Female</option>
                                    <option value="Transgender" <?php echo (isset($response['gender']) && $response['gender'] == 'other') ? 'selected' : ''; ?>>Transgender</option>
                                </select>
                            </div>
                            <div class="col-md-6">
                                <label for="spousename" class="form-label">Select Relation:</label>
                                <select class="form-control" id="spousename" name="spousename" required>
                                    <option value="">Select Relation</option>
                                    <option value="HUSBAND" <?php echo (isset($response['rln_type']) && $response['rln_type'] == 'H') ? 'selected' : ''; ?>>HUSBAND</option>
                                    <option value="FATHER" <?php echo (isset($response['rln_type']) && $response['rln_type'] == 'F') ? 'selected' : ''; ?>>FATHER</option>
                                    <option value="other" <?php echo (isset($response['rln_type']) && $response['rln_type'] == 'other') ? 'selected' : ''; ?>>Other</option>
                                </select>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                               <label for="dobhkb" class="form-label">Date of Birth / Age:</label>
                               <?php if (!empty($response['dob'])): ?>
                                   <input class="form-control" name="dobhkb" id="dob" type="text" placeholder="01/01/2000" value="<?php echo htmlspecialchars($response['dob']); ?>" autocomplete="off" required>
                               <?php elseif (!empty($response['age'])): ?>
                                   <input class="form-control" name="dobhkb" id="dobAge" type="text" value="<?php echo htmlspecialchars($response['age']); ?>" readonly onclick="switchToCalendar(this)">
                               <?php else: ?>
                                   <input class="form-control" name="dobhkb" id="dob" type="text" placeholder="01/01/2000" autocomplete="off" required>
                               <?php endif; ?>
                            </div>
                            <div class="col-md-6">
                                <label for="assemblyconnameno" class="form-label">Assembly Constituency:</label>
                                <input class="form-control" name="assemblyconnameno" id="assemblyconnameno" type="text" placeholder="23 - Ramgarh" value="<?php echo isset($response['ac_no'], $response['ac_name']) ? $response['ac_no'] . ' - ' . $response['ac_name'] : ''; ?>" autocomplete="off" required>
                            </div>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-8">
                            <label for="partname" class="form-label">Part Name:</label>
                            <input type="text" class="form-control" name="partname" id="partname" value="<?php echo isset($response['part_name']) ? ucwords($response['part_name']) : ''; ?>" placeholder="Enter Part Name" autocomplete="off" required>
                        </div>
                            <div class="col-md-4">
                                <label for="tahshil" class="form-label">Tahshil:</label>
                             <input class="form-control border-primary" name="tahshil" id="tehsil" type="text" value="<?php echo isset($response['district']) ? ucwords($response['district']) : ''; ?>" placeholder="Tahshil" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="address" class="form-label">Full Address:</label>
                            <textarea class="form-control" id="txtSource" name="address" placeholder="210, Balua, Sindhu, Riga, Tamil, Tamil Nadu-110001" rows="3" style="resize: none;" required><?php  
                            echo isset($response['part_name'], $response['ac_name'], $response['district'], $response['state']) 
                                    ? ','.$response['part_name'] . ', ' . $response['ac_name'] . ', ' . $response['district'] . ', ' . $response['state'] 
                                    : ''; ?>
                            </textarea>
                        </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="card border">
                <div class="card-header text-white bg-primary">
                    <h6 class="mb-0">Voter Details in Regional</h6>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                      <div class="col-md-6">
                        <label for="houseNo" class="form-label">House Number:</label>
                        <input class="form-control" name="houseNo" id="houseNo" type="text" placeholder="flat-310" value="" autocomplete="off" required>
                      </div>
                        <div class="col-md-6">
                        <label for="language" class="form-label">Select Language:</label>
                        <select class="form-control" id="language" name="language" required>
                            <option value="">Select Language</option>
                            <option value="HI">Hindi</option>
                            <option value="PA">Punjabi</option>
                            <option value="GU">Gujarati</option>
                            <option value="MR">Marathi</option>
                            <option value="TA">Tamil</option>
                            <option value="KN">Kannada</option>
                            <option value="BN">Bengali</option>
                            <option value="TE">Telugu</option>
                            <option value="OR">Oriya</option>
                            <option value="SD">Sindhi</option>
                        </select>
                    </div>
                    </div>
                    <div class="mb-3">
                        <label for="namelocal" class="form-label">Name (Regional):</label>
                        <input class="form-control border-primary" name="namelocal" id="name_regional" type="text" placeholder="Auto fetched when Language Select"  value="<?php echo isset($response['name_v1']) ? $response['name_v1'] : ''; ?>">
                    </div>
                    <div class="mb-3">
                        <label for="fathernamelocal" class="form-label">Father / Husband (Regional):</label>
                        <input type="text" class="form-control border-primary" name="fathernamelocal" id="fathernamelocal" autocomplete="off" value="<?php echo isset($response['rln_name_v1']) ? $response['rln_name_v1'] : ''; ?>" placeholder="Auto fetched when Language Select" required>
                    </div>
                    <div class="row mb-3">
                    <div class="col-md-6">
                        <label for="genderlocal" class="form-label">Gender (Regional):</label>
                        <input type="text" class="form-control border-primary" name="genderlocal" id="genderlocal" autocomplete="off" placeholder="Auto fetched when Language Select" required>
                    </div>
                    <div class="col-md-6">
                        <label for="birthtithilocal" class="form-label">DOB (Regional):</label>
                        <input class="form-control" id="birthtithi" name="birthtithi" type="hidden" value="BirthTithi / Age ">
                        <input class="mng_cp form-control border-primary" id="birthtithilocal" name="birthtithilocal" autocomplete="off" type="text" placeholder="Auto fetched when Language Select" required>
                     </div>
                    </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label for="assemblyconnamenolocal" class="form-label">Assembly Constituency (Regional):</label>
                                <input class="form-control" name="assemblyconnamenolocal" id="assemblyconnamenolocal" type="text" placeholder="Auto fetched when Language Select" value="<?php echo isset($response['ac_no'], $response['dist_name_v1']) ? $response['ac_no'] . ' - ' . $response['dist_name_v1'] : ''; ?>" autocomplete="off" required>
                            </div>
                            <div class="col-md-6">
                                <label for="partno" class="form-label">Part Number:</label>
                                <input class="form-control" name="partno" id="partno" type="number" placeholder="806" value="<?php echo isset($response['part_no']) ? $response['part_no'] : ''; ?>" autocomplete="off" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label for="partnamelocal" class="form-label">Part Name (Regional):</label>
                            <input type="text" class="form-control" name="partnamelocal" id="partnamelocal" placeholder="Enter Part Name" value="<?php echo isset($response['part_name_v1']) ? $response['part_name_v1'] : ''; ?>" autocomplete="off" required>
                            <input class="form-control" id="pata" name="pata" type="hidden" value="address">
                            <input class="form-control" id="patalocal" name="patalocal" type="hidden" value="">
                            <input class="form-control" id="spousenamelocal" name="spousenamelocal" type="hidden" value="">
                            <input class="form-control" id="kaname" name="kaname" type="hidden" value="Ka Name">
                            <input class="form-control" id="kanamelocal" name="kanamelocal" type="hidden" value="">
                            <input class="form-control" id="sex" name="sex" readonly type="hidden" value="gender">
                            <input class="form-control" id="sexlocal" name="sexlocal" type="hidden" value="">
                            <input class="form-control" id="sign" name="sign" type="hidden" value="Electoral Registration Officer">
                            <input class="form-control" id="signlocal" name="signlocal" type="hidden" value="">
                            <input class="form-control" id="assconnameno" name="assconnameno" type="hidden" value="Assembly Constituency Number and Name">
                            <input class="form-control" id="assconnamenolocal" name="assconnamenolocal" type="hidden" value="">
                            <input class="form-control" id="partnoandname" name="partnoandname" type="hidden" value="Part Number and Name">
                            <input class="form-control" id="partnoandnamelocal" name="partnoandnamelocal" type="hidden" value="">
                            <input class="form-control" id="state" name="state" type="hidden" value="<?php echo isset($response['state']) ? $response['state'] : ''; ?>">
                        </div>
                    <div class="mb-3">
                        <label for="addresslocal" class="form-label">Full Address (Regional):</label>
                        <textarea type="text" id="txtTarget" class="form-control" name="addresslocal" placeholder="Auto fetched when Language Select" rows="3" required><?php  
                        echo isset($response['part_name_v1'], $response['ac_name_v1'], $response['dist_name_v1'], $response['state_v1']) 
                                    ? $response['part_name_v1'] . ', ' . $response['ac_name_v1'] . ', ' . $response['dist_name_v1'] . ', ' . $response['state_v1'] 
                                    : ''; ?>
                        </textarea>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-2">
            <div class="card border">
                <div class="card-header text-white bg-primary">
                    <h6 class="mb-0 text-center">Photo</h6>
                </div>
                <div class="card-body text-center">
                    <div style="width: 150px; height: 150px; border: 1px solid #ccc; display: flex; align-items: center; justify-content: center; margin: auto;">
                        <img id="imagePreview" src="" alt="Selected Image" style="max-width: 100%; max-height: 100%; display: none;">
                    </div>
                    <input type="file" class="form-control mt-3" id="imageInput" name="imageInput" accept="image/*" onchange="previewImage()" required>
                    <small id="errorMessage" class="text-danger" style="display: none;"></small>
                    <hr>
                    <button class="btn btn-primary" type="submit" name="savedata">Submit / <small><i class="fas fa-inr"></i></small> <?php echo isset($user_data['voter_advance_fee']) ? $user_data['voter_advance_fee'] : '0'; ?></button>
                </div>
            </div>
        </div>
     </form>
    </div>
</div>
<script>
function previewImage() {
    const input = document.getElementById('imageInput');
    const preview = document.getElementById('imagePreview');
    const errorMessage = document.getElementById('errorMessage');
    const file = input.files[0];

    if (file) {
        const allowedTypes = ['image/jpeg', 'image/png', 'image/jpg'];
        const maxSize = 100 * 1024; // 100KB in bytes

        // Check file type
        if (!allowedTypes.includes(file.type)) {
            errorMessage.textContent = 'Please upload a valid image (JPG, JPEG, or PNG).';
            errorMessage.style.display = 'block';
            input.value = ''; // Reset the input field
            preview.src = '';
            preview.style.display = 'none'; // Hide preview
            return;
        }

        // Check file size
        if (file.size > maxSize) {
            errorMessage.textContent = 'Image size must be less than 100KB.';
            errorMessage.style.display = 'block';
            input.value = ''; // Reset the input field
            preview.src = '';
            preview.style.display = 'none'; // Hide preview
            return;
        }

        // If file is valid, preview the image
        const reader = new FileReader();
        reader.onload = function (e) {
            preview.src = e.target.result;
            preview.style.display = 'block';
            errorMessage.style.display = 'none'; // Hide error message
        };
        reader.readAsDataURL(file);
    } else {
        // No file selected
        preview.src = '';
        preview.style.display = 'none';
        errorMessage.style.display = 'none'; // Hide error message
    }
}



    document.getElementById('houseNo').addEventListener('input', function() {
        const houseNoValue = this.value.trim();
        const addressField = document.getElementById('txtSource');
        let addressValue = addressField.value.trim();
        if (addressValue.includes(',')) {
            const parts = addressValue.split(',');
            parts.shift(); // Remove the first part (old houseNo)
            addressValue = parts.join(',').trim();
        }
        addressField.value = houseNoValue ? `${houseNoValue}, ${addressValue}` : addressValue;
    });
    document.getElementById('txtSource').addEventListener('input', function() {
        const houseNoValue = document.getElementById('houseNo').value.trim();
        let currentAddress = this.value.trim();
        
        if (!currentAddress.startsWith(houseNoValue) && houseNoValue) {
            this.value = `${houseNoValue}, ${currentAddress}`;
        }
    });

function switchToCalendar(el) {
    // Replace Age input with calendar-enabled DOB field dynamically
    const parent = el.parentNode;
    const newInput = document.createElement('input');
    newInput.className = 'form-control';
    newInput.name = 'dobhkb';
    newInput.id = 'dob';
    newInput.type = 'text';
    newInput.placeholder = '01/01/2000';
    newInput.required = true;
    el.remove();
    parent.appendChild(newInput);

    // Initialize Flatpickr again for the new element
    flatpickr("#dob", {
        dateFormat: "d/m/Y",
        allowInput: true,
        maxDate: "today"
    });
}

</script>
  <script type="text/javascript">
  $('#language').on('change',function(){
  if($(this).val() != '' && $(this).val() == 'OR'){
		var langs = $(this).val();
		var lang = langs.toLowerCase();
        var name = $("#name").val();
        var address = $("#txtSource").val();
        var fathername = $("#fathername").val();
        var assemblyconnameno = $("#assemblyconnameno").val();
        var partname = $("#partname").val();
        var spousename = $("#spousename").val();
        var kaname = $("#kaname").val();
        var sex = $("#sex").val();
        var sign = $("#sign").val();
        var partnoandname = $("#partnoandname").val();
        var assconnameno = $("#assconnameno").val();
        $.post("<?php echo "http://" . $_SERVER['SERVER_NAME'].'/admin/';?>test",{lang:lang,name:name,address:address}).done(function (data) {
        $("[name='namelocal']").val(json.name.replace(/"/g,''));
        $("[name='addresslocal']").val(json.address.replace(/"/g,''));
        $("[name='fathernamelocal']").val(json.fathername.replace(/"/g,''));
        $("[name='assemblyconnamenolocal']").val(json.assemblyconnameno.replace(/"/g,''));
        $("[name='partnamelocal']").val(json.partname.replace(/"/g,''));
        $("[name='spousenamelocal']").val(json.spousename.replace(/"/g,''));
        $("[name='kanamelocal']").val(json.kaname.replace(/"/g,''));
        $("[name='sexlocal']").val(json.sex.replace(/"/g,''));
        $("[name='signlocal']").val(json.sign.replace(/"/g,''));
        $("[name='assconnamenolocal']").val(json.assconnameno.replace(/"/g,''));
        $("[name='partnoandnamelocal']").val(json.partnoandname.replace(/"/g,''));
        })
        
        
        
        
        var dob = $("#birthtithi").val();
        if($(this).val() == 'HI' &&  $("#gender").val() =='Male'){
          var gender = $("#gender").val('पुरुष');
        }else {
          var gender = $("#gender").val();
        }
        $.post("<?php echo "http://" . $_SERVER['SERVER_NAME'].'/admin/';?>test",{lang:lang,name:dob,address:gender}).done(function (data) {
        $("[name='birthtithilocal']").val(json.name.replace(/"/g,''));
        $("[name='genderlocal']").val(json.address.replace(/"/g,''));
        })
        }else{
        changelang();   
        }
        });
        
  </script> 
<script type="text/javascript">
    function changelang() {
            var lang = document.getElementById("language").value;
            var url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#txtSource").val());
            $.get(url, function (data, status) {
                var result= '';
                for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#txtTarget").val(result);
			      }
            });	

            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#name").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#name_regional").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#fathername").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#fathernamelocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#assemblyconnameno").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#assemblyconnamenolocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#partname").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#partnamelocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#spousename").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#spousenamelocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#kaname").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#kanamelocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#sex").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#sexlocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#sign").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#signlocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#assconnameno").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#assconnamenolocal").val(result);
			      }
            });	
            
            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#partnoandname").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#partnoandnamelocal").val(result);
			      }
            });	
            
            var gen = $("#gender").val();
            url ="https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape(gen.toLowerCase());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      
            if(result == 'नर'){
                result = 'पुरुष';
            }
              $("#genderlocal").val(result);
            }
            });

            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#birthtithi").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
			      $("#birthtithilocal").val(result);
			    }
            });

            url = "https://translate.googleapis.com/translate_a/single?client=gtx";
            url += "&sl=" + 'EN';
            url += "&tl=" + lang;
            url += "&dt=t&q=" + escape($("#pata").val());
            $.get(url, function (data, status) {
			 var result= '';
			  for(var i=0; i<=500; i++){
			      result += data[0][i][0];
				  $("#patalocal").val(result);
				  
			    }
            });
		};	
</script> 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.maskedinput/1.4.1/jquery.maskedinput.js"></script> 
<?php } else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any Voter Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>