<?php
require_once("../layouts/members/head.php");
if ($user_data['voter_Pdf_Service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $epicNumber = strtoupper($_POST['epicNumber']);

              if (!empty($epicNumber)) {
                  $amount = $user_data['voter_pdf_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'voterNumber' => $epicNumber,
                      ];

                      $responseApi = voter_pdf_send_otp_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          alert_msg($response['message'], 'success', 0);
                      }else{
                          alert_msg($response['error'], 'danger');
                      }
                      } else {
                          awal_alert_msg("Insufficient Wallet Balance!", 'error');
                      }
                  } else {
                      awal_alert_msg("Voter Number cannot be empty!", 'error');
                  }
              }
              
          if (isset($_POST['submitotp'])) {
              $voterNumber = strtoupper($_POST['voterNumber']);
              $otp = strtoupper($_POST['otp']);
              $stateCd = strtoupper($_POST['stateCd']);

              if (!empty($voterNumber) && !empty($otp) && !empty($stateCd)) {
                  $amount = $user_data['voter_pdf_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'voterNumber' => $voterNumber,
                          'stateCd' => $stateCd,
                          'otp' => $otp,
                      ];

                      $responseApi = voter_pdf_verify_otp_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "VOTERPDF",
                                  'type'          => "Debit",
                                  'account_number'=> $response['epicNo'],
                                  'app_type'      => "VOTERPDF",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['epicNo'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Srno {$response['refrenceNo']} Voter Number ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                 $fields = [
                                     'epicNo' => 'Voter No',
                                     'refrenceNo' => 'Sr NO',
                                 ];

                                 $whamessage = "Dear {$user_data['name']},\nYour Request for Voter Number *{$voterNumber}* PDF has been Complete.\n\n";

                                 foreach ($fields as $key => $label) {
                                     if (!empty($response[$key])) {
                                         $whamessage .= "*$label*: {$response[$key]}\n";
                                     }
                                 }
                                 $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <?php if (!isset($response['name']) || $response['name'] == '') { ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Voter Number</label>
              <input type="text" name="epicNumber" placeholder="Enter Voter Number" maxlength="45" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==45) return false;" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['voter_pdf_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
          
          <?php }else{ ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Secret Code</label>
              <input type="number" name="otp" placeholder="Enter 6 Digit OTP" maxlength="6" class="form-control" onkeypress="if(this.value.length==6) return false;" required>
              <input type="hidden" name="stateCd" value="<?php echo isset($response['stateCd']) ? $response['stateCd'] : ''; ?>" class="form-control" required>
              <input type="hidden" name="voterNumber" value="<?php echo isset($response['voterno']) ? $response['voterno'] : ''; ?>" class="form-control" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['voter_pdf_fee'];?></button>
              <button type="submit" name="submitotp" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
          <?php } ?>
        </div>
      </div>
    </div>
    
<?php if (isset($response['pdf']) && !empty($response['pdf'])) { ?>
  <div class="col-md-8 mb-2">
    <div class="card text-danger">
      <div class="card-header bg-primary text-white py-2">
        <span><?php echo htmlspecialchars($response['epicNo']); ?>, your PDF is ready to download...</span>
        <a href="<?php echo htmlspecialchars($response['pdf']); ?>" download="<?php echo htmlspecialchars($response['epicNo']); ?>.pdf" class="btn btn-warning">
          <i class="fas fa-download"></i> Download PDF
        </a>
      </div>
      <iframe src="<?php echo htmlspecialchars($response['pdf']); ?>" 
              style="width: 100%; height: 600px; border: 1px solid #ccc;" frameborder="0">
      </iframe>
    </div>
  </div>
<?php } ?>
</div>

<!-- Modal to show fetched details -->
<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['name']) && !empty($response['name'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>Voter Number</label>
              <input type="text" value="<?= htmlspecialchars($response['voterno']) ?>" class="form-control" readonly>
            </div>
            <div class="col-md-6 mb-3">
              <label>Name</label>
              <input type="text" value="<?= htmlspecialchars($response['name']) ?>" class="form-control" readonly>
              </div>
          </form>
        <?php } else { ?>
          <p>No details fetched yet. Submit Voter Number to Download PDF.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['name']) && !empty($response['name'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any Voter Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
