<?php
require_once("../layouts/members/head.php");
if ($user_data['voter_Mobile_Link_Service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;

          if (isset($_POST['submit'])) {
              $voterNumber = strtoupper($_POST['voterNumber']);
              $mobileNumber = $_POST['mobileNumber'];
               
              if (!empty($voterNumber) && !empty($mobileNumber)) {
                  $amount = $user_data['voter_mobile_link_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'voterNumber'  => $voterNumber,
                          'mobileNumber' => $mobileNumber,
                          'order_id'     => $order_id,
                      ];

                      $responseApi = VoterMobileLink_WithoutOTP_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "VOTER MOBILE LINK WITHOUT OTP",
                                  'type'          => "Debit",
                                  'account_number'=> $response['voterNumber'],
                                  'app_type'      => "VOTER MOBILE LINK WITHOUT OTP",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['voterNumber'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for VOTER MOBILE LINK WITHOUT OTP By Epic Number ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                 $fields = [
                                     'voterNumber' => 'Epic No',
                                     'refrenceNo'  => 'Refrence No',
                                     'name'        => 'Name',
                                     'state'       => 'State',
                                     'mobileNumber'=> 'Mobile No',
                                     'message'     => 'Message',
                                 ];

                                 $whamessage = "Dear {$user_data['name']},\nYour Request for Epic Number *{$voterNumber}* Mobile Link has been Complete.\n\n";

                                 foreach ($fields as $key => $label) {
                                     if (!empty($response[$key])) {
                                         $whamessage .= "*$label*: {$response[$key]}\n";
                                     }
                                 }
                                 $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Voter Number</label>
              <input type="text" name="voterNumber" placeholder="Enter Voter Number" maxlength="25" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==25) return false;" required>
            </div>
            <div class="col-md-12 mb-3">
              <label>Mobile Number</label>
              <input type="number" name="mobileNumber" placeholder="954785****" maxlength="10" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==10) return false;" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['voter_mobile_link_fee'];?></button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
        </div>
      </div>
    </div>


<!-- Modal to show fetched details -->
<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['voterNumber']) && !empty($response['voterNumber'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>Voter Number</label>
              <input type="text" value="<?= htmlspecialchars($response['voterNumber']) ?>" class="form-control" readonly>
            </div>
            <?php if (isset($response['name']) && !empty($response['name'])) { ?>
            <div class="col-md-6 mb-3">
              <label>Full Name</label>
              <input type="text" value="<?= htmlspecialchars($response['name']) ?>" class="form-control" readonly>
            </div>
             <?php } ?>
             <?php if (isset($response['refrenceNo']) && !empty($response['refrenceNo'])) { ?>
            <div class="col-md-6 mb-3">
              <label>Refrence No</label>
              <input type="text" value="<?= htmlspecialchars($response['refrenceNo']) ?>" class="form-control" readonly>
            </div>
             <?php } ?>
             <?php if (isset($response['state']) && !empty($response['state'])) { ?>
            <div class="col-md-6 mb-3">
              <label>State</label>
              <input type="text" value="<?= htmlspecialchars($response['state']) ?>" class="form-control" readonly>
              </div>
             <?php } ?>
             <?php if (isset($response['mobileNumber']) && !empty($response['mobileNumber'])) { ?>
            <div class="col-md-6 mb-3">
              <label>Mobile Number</label>
              <input type="text" value="<?= htmlspecialchars($response['mobileNumber']) ?>" class="form-control" readonly>
              </div>
             <?php } ?>
             <?php if (isset($response['message']) && !empty($response['message'])) { ?>
            <div class="col-md-6 mb-3">
              <label>Message</label>
              <input type="text" value="<?= htmlspecialchars($response['message']) ?>" class="form-control" readonly>
              </div>
             <?php } ?>
          </form>
        <?php } else { ?>
          <p>No details fetched yet. Submit Voter Number to Link Your Mobile Number.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['voterNumber']) && !empty($response['voterNumber'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

</div>

<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Voter Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
