<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <!-- Service Cards -->
  <?php 
  $services = [
    ['link' => 'Voter_Mobile_Link', 'img' => 'votermobilelink3.jpg', 'text' => 'Mobile Link', 'bg' => '#e6f7ff', 'show' => $user_data['voter_Mobile_Link_Service'] === "YES"],
    ['link' => 'Voter_Mobile_Link2', 'img' => 'votermobilelink3.jpg', 'text' => 'Mobile Link Without OTP', 'bg' => '#e6f7ff', 'show' => $user_data['voter_Mobile_Link_Service'] === "YES"],
    ['link' => 'Voter_Original_PDF', 'img' => 'pdf_doc.png', 'text' => 'Original PDF', 'bg' => '#fff5e6', 'show' => $user_data['voter_Pdf_Service'] === "YES"],
    ['link' => 'Voter_Print', 'img' => 'voter.png', 'text' => 'Advance V1', 'bg' => '#ffe6e6', 'show' => $user_data['voter_advance_Service'] === "YES"],
    ['link' => 'Voter_Print', 'img' => 'e_epic.png', 'text' => 'Advance V2', 'bg' => '#f2e6ff', 'show' => $user_data['voter_Manual_Service'] === "YES"],
  ];
  
foreach ($services as $service): 
    if (!$service['show']) {
      continue; 
    }
  ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
