<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <!-- Service Cards -->
  <?php 
  $services = [
    ['link' => 'LL_card', 'img' => 'pdf_doc.png', 'text' => 'Learning PDF', 'bg' => '#e6ffe6', 'show' => $user_data['learning_pdf_services'] === "YES"],
    ['link' => 'LL_application_find', 'img' => 'finder.png', 'text' => 'Learning Find', 'bg' => '#e1e6ed', 'show' => $user_data['learning_find_services'] === "YES"],
    ['link' => 'll_exam_Request', 'img' => 'test.png', 'text' => 'LL Exam', 'bg' => '#f2e6ff', 'show' => $user_data['ll_service'] === "YES"],
    ['link' => 'chassis_to_Rc', 'img' => 'best-credit-card-2.png', 'text' => 'Chassis To RC Find', 'bg' => '#e1e6ed', 'show' => $user_data['chassis2rc_services'] === "YES"],
    ['link' => 'DL_to_Mobile', 'img' => 'finder.png', 'text' => 'DL To Mobile Find', 'bg' => '#e1e6ed', 'show' => $user_data['dl_mobile_find_services'] === "YES"],
    ['link' => 'Rc_Guardian_Find', 'img' => 'vehical.png', 'text' => 'RC Father Find', 'bg' => '#e6f7ff', 'show' => $user_data['vehical_rc_father_find_Service'] === "YES"],
    ['link' => 'Rc_Verify', 'img' => 'rcpdf.jpeg', 'text' => 'Vehical RC PDF', 'bg' => '#ffe6e6', 'show' => $user_data['Rc_pdf_services'] === "YES"],
    ['link' => 'Rc_Verify', 'img' => 'vehical.png', 'text' => 'RC Verify PDF', 'bg' => '#e6f7ff', 'show' => $user_data['Rc_pdf_services'] === "YES"],
    ['link' => 'Driving_Licence_Pdf', 'img' => 'drivinglicence.png', 'text' => 'DL PDF V1', 'bg' => '#fff5e6', 'show' => $user_data['dl_pdf_service'] === "YES"],
    ['link' => 'Driving_Licence_Pdf_2', 'img' => 'drivinglicencechip.png', 'text' => 'DL PDF Chip V2', 'bg' => '#f2e6ff', 'show' => $user_data['dl_pdf_service'] === "YES"],
    ['link' => 'DL_Find', 'img' => 'finder.png', 'text' => 'DL Find', 'bg' => '#e6ffe6', 'show' => $user_data['dl_find_service'] === "YES"],
    ['link' => 'Challan_Find', 'img' => 'challan.png', 'text' => 'Challan Find', 'bg' => '#e6ffe6', 'show' => $user_data['challan_Check_Service'] === "YES"],
  ];
  
foreach ($services as $service): 
    if (!$service['show']) {
      continue; 
    }
  ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
