<?php
require_once("../layouts/members/head.php");
if ($user_data['eshram_services'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $uidNumber = $_POST['uidNumber'] ?? '';

              if (!empty($uidNumber)) {
                  $amount = $user_data['uid_to_details_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'uidNumber' => $uidNumber,
                      ];

                      $responseApi = uid_to_instant_detilas_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "UID_TO_INSTANT_DETAILS",
                                  'type'          => "Debit",
                                  'account_number'=> $response['aadhar'],
                                  'app_type'      => "UID_TO_INSTANT_DETAILS",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['aadhar'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for UID_TO_INSTANT_DETAILS Name {$response['name']} UID ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'aadhar' => 'Uid No',
                                      'name' => 'Name',
                                      'dob' => 'Dob',
                                      'gender' => 'Gender',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Phone *{$uidNumber}* To UID Verification has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && isset($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }

                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Aadhaar Number <sup style="color:blue; font-weight:bold;">Data will come only when e-Shram is created</sup></label>
              <input type="number" name="uidNumber" placeholder="Enter Aadhaar Number" maxlength="12" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==12) return false;"required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['uid_to_details_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- Display Datatable Section -->
    <?php if (isset($response['status']) && $response['status'] == '100') {  ?>
<div class="col-md-8 mb-2">
  <div class="card text-danger">
    <div class="card-header bg-danger text-white py-2">
      <span class="mr-auto">Details Searching Complete UID No: <strong><?= $uidNumber ?? 'N/A'; ?></strong></span>
    </div>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <tbody>
          <?php if (!empty($response['aadhar'])): ?>
          <tr>
            <td><strong>UID Number</strong></td>
            <td><?= htmlspecialchars($response['aadhar']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['name'])): ?>
          <tr>
            <td><strong>Name</strong></td>
            <td><?= htmlspecialchars($response['name']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['dob'])): ?>
          <tr>
            <td><strong>Dob</strong></td>
            <td><?= htmlspecialchars($response['dob']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (isset($response['gender'])): ?>
          <tr>
            <td><strong>Gender</strong></td>
            <td><?= htmlspecialchars($response['gender']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (isset($response['address'])): ?>
          <tr>
            <td><strong>Address</strong></td>
            <td><?= htmlspecialchars($response['address']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (isset($response['image'])): ?>
          <tr>
            <td><strong>Image</strong></td>
            <td><img src="<?= htmlspecialchars($response['image']); ?>" alt="Image" style="max-width:150px;"/></td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any e-Shram Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
