<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <!-- Service Cards -->
  <?php 
  $services = [
    ['link' => 'Aadhar_MobileVerify', 'img' => 'fingerprint2.png', 'text' => 'FingerPrint 1', 'bg' => '#ffe6e6', 'show' => $user_data['aadhar_fingerPrint_service'] === "YES"],
    ['link' => 'aadhar_Fingerprint', 'img' => 'aadharfinger.png', 'text' => 'FingerPrint 2', 'bg' => '#ffe6e6', 'show' => $user_data['aadhar_fingerPrint_service'] === "YES"],
    ['link' => 'aadhar_Fingerprint', 'img' => 'fingerprint2.png', 'text' => 'FingerPrint 3', 'bg' => '#ffe6e6', 'show' => $user_data['aadhar_fingerPrint_service'] === "YES"],
    ['link' => 'aadhar_Otp', 'img' => 'otp.png', 'text' => 'Aadhar OTP', 'bg' => '#e6f7ff', 'show' => $user_data['aadhar_otp_service'] === "YES"],
    ['link' => 'Aadhar_Manual', 'img' => 'aadhar.png', 'text' => 'Aadhar Manual', 'bg' => '#ffe6e6', 'show' => $user_data['aadhar_manual_service'] === "YES"],
    ['link' => 'Npci_Link_Status', 'img' => 'npci.png', 'text' => 'NPCI Bank Status', 'bg' => '#ffe6e6', 'show' => $user_data['npci_service'] === "YES"],
    ['link' => 'Pmjay_Verify', 'img' => 'ayushmancard.png', 'text' => 'Pmjay Card', 'bg' => '#e1e6ed', 'show' => $user_data['ayushman_service'] === "YES"],
    ['link' => 'Uid_to_Details', 'img' => 'aadhareshram.png', 'text' => 'UID TO Full Details', 'bg' => '#e1e6ed', 'show' => $user_data['eshram_services'] === "YES"],
    ['link' => 'e-shram_verification', 'img' => 'eshramlogo.png', 'text' => 'e-Shram Card', 'bg' => '#f2e6ff', 'show' => $user_data['eshram_services'] === "YES"],
    ['link' => 'panfind', 'img' => 'aadhartopan.png', 'text' => 'Aadhar To Pan', 'bg' => '#fff5e6', 'show' => $user_data['pandfind_service'] === "YES"],
    ['link' => 'aadhartomaskpan', 'img' => 'best-credit-card-2.png', 'text' => 'Aadhar to Mask Pan', 'bg' => '#e1e6ed', 'show' => $user_data['aadhar_to_maskpan_service'] === "YES"],
    ['link' => 'Pantomaskaadhaar', 'img' => 'maskaadhar.png', 'text' => 'PAN to Mask Aadhar', 'bg' => '#e6ffe6', 'show' => $user_data['pan_to_maskuid_service'] === "YES"],
    ['link' => 'PanuidLinkStatuscheck', 'img' => 'panaadharlink.png', 'text' => 'Pan Aadhar Link', 'bg' => '#f2e6ff', 'show' => $user_data['aadhar_to_panLink_service'] === "YES"],
    ['link' => 'Aadhar_Verify', 'img' => 'Aadhar-status-1.jpg', 'text' => 'Aadhar No. Verify', 'bg' => '#ffe6e6', 'show' => $user_data['aadhar_Verify_service'] === "YES"],
    ['link' => 'Enrollment_Status', 'img' => 'eiddstatus.png', 'text' => 'Enrollment Status', 'bg' => '#e6f7ff', 'show' => $user_data['eid_Status_service'] === "YES"],
  ];
  
  foreach ($services as $service): 
    if (!$service['show']) {
      continue; 
    }
  ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
