<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <!-- Service Cards -->
  <?php 
  $services = [
    ['link' => 'Ration_Pdf', 'img' => 'Rationpdf.png', 'text' => 'Ration PDF', 'bg' => '#ffe6e6', 'show' => $user_data['ration_to_pdf_Service'] === "YES"],
    ['link' => 'Ration_Pdf_by_aadhaar', 'img' => 'aadhar2ration.png', 'text' => 'AADHAR TO PDF', 'bg' => '#e6f7ff', 'show' => $user_data['uid_ration_pdf_Service'] === "YES"],
    ['link' => 'Ration_uid_finder', 'img' => 'ration2aadharfinderr.png', 'text' => 'Ration to Aadhar-1', 'bg' => '#e6ffe6', 'show' => $user_data['rationto_uid_find_service'] === "YES"],
    ['link' => 'Ration_uid_find', 'img' => 'ration2aadharfinderr.png', 'text' => 'Ration to Aadhar-2', 'bg' => '#e6ffe6', 'show' => $user_data['rationto_uid_find_service'] === "YES"],
    ['link' => 'familyID_Verification', 'img' => 'familyid.png', 'text' => 'FamilyID Card', 'bg' => '#f2e6ff', 'show' => $user_data['familyid_service'] === "YES"],
  ];
  
  foreach ($services as $service): 
    if (!$service['show']) {
      continue; 
    }
  ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
