<?php
require_once("../layouts/members/head.php");
if ($user_data['pan_to_maskuid_service'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
             <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()" > <i class="fas fa-arrow-left"></i> Back</button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;

          if (isset($_POST['submit'])) {
              $panNumber = is_valid_pan($_POST['panNumber']);

              if (!empty($panNumber)) {
                  $amount = $user_data['pan_uid_status_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($user_data['balance'] >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'panNumber' => $panNumber,
                          'order_id' => $order_id
                      ];

                      $responseApi = pantomaskaadhar_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], " user_id='" . $user_data['user_id'] . "' ");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "PAN TO MASK UID",
                                  'type'          => "Debit",
                                  'account_number'=> $panNumber,
                                  'app_type'      => "PAN TO MASK UID",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['aadhar'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for PAN {$panNumber} MASK UID ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                 $fields = [
                                     'pan' => 'PAN',
                                     'aadhar' => 'UID',
                                 ];

                                 $whamessage = "Dear {$user_data['name']},\nYour Request for PAN *{$panNumber}* To mask Aadhar has been Complete.\n\n";

                                 foreach ($fields as $key => $label) {
                                     if (!empty($response[$key])) {
                                         $whamessage .= "*$label*: {$response[$key]}\n";
                                     }
                                 }
                                 $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'],$whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Pan Number</label>
                <input type="text" name="panNumber" placeholder="Enter PAN Number" maxlength="10" class="form-control" 
                pattern="^[A-Z]{5}[0-9]{4}[A-Z]{1}$" title="PAN number must be in the format of AAAAA1234A" oninput="this.value = this.value.toUpperCase()"
                onkeypress="if(this.value.length==10) return false;" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <!-- Application Charge Button -->
              <button type="button" class="btn btn-secondary" ><i class="fas fa-inr"></i> <?php echo $user_data['pan_to_mask_uid_fee'];?></button>
              <!-- Submit Button -->
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
              <button type="button" class="btn btn-warning" data-toggle="modal" data-target="#showDetailsModal">Show</button>
            </div>
          </form>
        </div>
      </div>
    </div>
</div>

<!-- Modal to show fetched details -->
<div class="modal fade" id="showDetailsModal" tabindex="-1" role="dialog" aria-labelledby="showDetailsModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="showDetailsModalLabel">Fetched Details</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
    <?php if (isset($response['aadhar']) && !empty($response['aadhar'])) { ?>
          <form class="row">
            <div class="col-md-6 mb-3">
              <label>PAN Number</label>
              <input type="text" value="<?= htmlspecialchars($panNumber) ?>" class="form-control" readonly>
            </div>
             <?php if (isset($response['aadhar']) && !empty($response['aadhar'])) { ?>
            <div class="col-md-6 mb-3">
              <label>Aadhaar Number</label>
              <input type="text" value="<?= htmlspecialchars($response['aadhar']) ?>" class="form-control" readonly>
              </div>
             <?php } ?>
        <?php } else { ?>
          <p>No details fetched yet. Submit PAN Number to fetch mask Aadhaar Number 12xxxxxxxxx54.</p>
        <?php } ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script>
  <?php if (isset($response['aadhar']) && !empty($response['aadhar'])) { ?>
    $(document).ready(function() {
      $('#showDetailsModal').modal('show');
    });
  <?php } ?>
</script>

<?php
} else {
    require_once("404.php");
}
} else {
      awal_alert_msg('You Do Not Have Any PAN Service Active!', 'info', 'dashboard');
}
require_once("../layouts/members/foot.php");
?>
