<?php
require_once("../layouts/members/head.php");
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $phoneNumber = $_POST['phoneNumber'] ?? '';

              if (!empty($phoneNumber)) {
                  $amount = $user_data['mobile_verify_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'phoneNumber' => $phoneNumber,
                      ];

                      $responseApi = mobile_operator_verify_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "MOBILEVERIFY",
                                  'type'          => "Debit",
                                  'account_number'=> $response['MobileNumber'],
                                  'app_type'      => "MOBILEVERIFY",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['MobileNumber'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for MOBILEVERIFY Name {$response['provider']} IFSC code ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'MobileNumber' => 'Mobile No',
                                      'provider' => 'Provider',
                                      'location' => 'Location',
                                      'postpaid' => 'Postpaid',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Phone *{$phoneNumber}* To Provider Verification has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && isset($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }

                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Mobile Number</label>
              <input type="number" name="phoneNumber" placeholder="Enter Mobile Number" maxlength="10" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==10) return false;"required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['mobile_verify_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- Display Datatable Section -->
    <?php if (isset($response['status']) && $response['status'] == '100') {  ?>
<div class="col-md-8 mb-2">
  <div class="card text-danger">
    <div class="card-header bg-danger text-white py-2">
      <span class="mr-auto">Details Searching Complete Mobile No: <strong><?= $phoneNumber ?? 'N/A'; ?></strong></span>
    </div>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <tbody>
          <?php if (!empty($response['MobileNumber'])): ?>
          <tr>
            <td><strong>Mobile Number</strong></td>
            <td><?= htmlspecialchars($response['MobileNumber']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['provider'])): ?>
          <tr>
            <td><strong>Provider</strong></td>
            <td><?= htmlspecialchars($response['provider']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['location'])): ?>
          <tr>
            <td><strong>Location</strong></td>
            <td><?= htmlspecialchars($response['location']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (isset($response['postpaid'])): ?>
          <tr>
            <td><strong>Postpaid</strong></td>
            <td><?= $response['postpaid'] === true ? 'True' : ($response['postpaid'] === false ? 'False' : htmlspecialchars($response['postpaid'])); ?></td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}

require_once("../layouts/members/foot.php");
?>
