<?php
require_once("../layouts/members/head.php");
if ($user_data['dl_mobile_find_services'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $dlNumber = $_POST['dlNumber'] ?? '';
              $dob = strtoupper(trim($_POST['dob']));
              
              if (!empty($dlNumber) && !empty($dob)) {
                  $amount = $user_data['dl_mobile_find_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'dlNumber' => $dlNumber,
                          'dob'      => $dob,
                      ];

                      $responseApi = Dl2_Mobile_find_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "DL TO MOBILE FIND",
                                  'type'          => "Debit",
                                  'account_number'=> $response['dlno'],
                                  'app_type'      => "DL TO MOBILE FIND",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['dlno'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Mobile Number {$response['mobileno']} DL ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'dlno'       => 'DL No',
                                      'name'       => 'Name',
                                      'dob'        => 'DOB',
                                      'fathername' => 'Gurdian',
                                      'mobileno'   => 'Mobile No',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Mobile Number Find *{$dlNumber}* To DL Verification has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && isset($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }

                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error');
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>DL Number</label>
              <input type="text" name="dlNumber" placeholder="Enter DL Number" maxlength="25" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==25) return false;" required>
            </div>
            <div class="col-md-12 mb-3">
              <label>Date of Birth</label>
              <input type="text" name="dob" placeholder="Enter dob Number" maxlength="15" id="dob" class="form-control" autocomplete="off" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['dl_mobile_find_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <!-- Display Datatable Section -->
<?php if (isset($response['status']) && $response['status'] == '100') {  ?>
<div class="col-md-8 mb-2">
  <div class="card text-danger">
    <div class="card-header bg-danger text-white py-2">
      <span class="mr-auto">Details Searching Complete DL No: <strong><?= $dlNumber ?? 'N/A'; ?></strong></span>
    </div>
    <div class="table-responsive">
      <table class="table table-bordered table-striped">
        <tbody>
          <?php if (!empty($response['dlno'])): ?>
          <tr>
            <td><strong>DL Number</strong></td>
            <td><?= htmlspecialchars($response['dlno']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['name'])): ?>
          <tr>
            <td><strong>Owner</strong></td>
            <td><?= htmlspecialchars($response['name']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['dob'])): ?>
          <tr>
            <td><strong>Date of Birth</strong></td>
            <td><?= htmlspecialchars($response['dob']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['fathername'])): ?>
          <tr>
            <td><strong>Gurdian</strong></td>
            <td><?= htmlspecialchars($response['fathername']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['mobileno'])): ?>
          <tr>
            <td><strong>Mobile Number</strong></td>
            <td><?= htmlspecialchars($response['mobileno']); ?></td>
          </tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

    <?php } ?>
</div>
<script>
  flatpickr("#dob", {
    dateFormat: "d-m-Y", 
    allowInput: true,   
    maxDate: "today",  
    onChange: function(selectedDates, dateStr, instance) {
      console.log("Selected date:", dateStr); 
    }
  });
</script>
<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any Vehical Service Active!', 'info', 'dashboard');
}

require_once("../layouts/members/foot.php");
?>
