<?php
require_once("../layouts/members/head.php");
if ($user_data['farmer_services'] == "YES") {
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $apiResponseData = null;
          if (isset($_POST['submit'])) {
              $uidNumber = $_POST['uidNumber'] ?? '';

              if (!empty($uidNumber)) {
                  $amount = $user_data['Agrifarmer_Status_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      $request = [
                          'uidNumber' => $uidNumber,
                      ];

                      $responseApi = farmeragriCheckStatus_api_run($request);
                      $response = json_decode($responseApi, true) ?? '';

                      if (isset($response['status']) && $response['status'] == '100') {
                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "Agri_Farmer_Status",
                                  'type'          => "Debit",
                                  'account_number'=> $response['uid'],
                                  'app_type'      => "Agri_Farmer_Status",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $response['uid'],
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Aadhar Status {$response['approvalStatus']} Aadhar No ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  $fields = [
                                      'uid'         => 'Aadhar No',
                                      'approvalStatus'    => 'Status',
                                      'farmerName'        => 'Name',
                                      'farmerNumber'      => 'Farmer ID',
                                      'centralId'         => 'Central ID',
                                      'verifiedOn'        => 'Verified On',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for Aadhar Number *{$uidNumber}* To Agri Farmer Status Checking has been Complete.\n\n";
                                  foreach ($fields as $key => $label) {
                                      if (!empty($response[$key]) && isset($response[$key])) {
                                          $whamessage .= "*$label*: {$response[$key]}\n";
                                      }

                                  }
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          awal_alert_msg($response['error'] ?? 'Server Down', 'error'); 
                      }
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Aadhar Number</label>
              <input type="number" name="uidNumber" placeholder="Enter Aadhar Number" maxlength="12" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" onkeypress="if(this.value.length==12) return false;"required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['Agrifarmer_Status_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>

<?php if (isset($response['status']) && $response['status'] == '100') {  ?>
<div class="col-md-8 mb-2">
  <div class="card text-danger">
    <div class="card-header bg-danger text-white py-2">
      <span class="mr-auto">Details Searching Complete Aadhar No: <strong><?= $uidNumber ?? 'N/A'; ?></strong></span>
      
           <button class="btn btn-primary" onclick="printBill()">Print</button>
    </div>
    <div class="table-responsive" id="printSection">
      <table class="table table-bordered table-striped">
        <tbody>
          <?php if (!empty($response['uid'])): ?>
          <tr>
            <td><strong>Aadhar Number</strong></td>
            <td><?= htmlspecialchars($response['uid']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['approvalStatus'])): ?>
          <tr>
            <td><strong>Status</strong></td>
            <td><?= htmlspecialchars($response['approvalStatus']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['farmerName'])): ?>
          <tr>
            <td><strong>Farmer Name</strong></td>
            <td><?= htmlspecialchars($response['farmerName']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['farmerNumber'])): ?>
          <tr>
            <td><strong>Farmer ID</strong></td>
            <td><?= htmlspecialchars($response['farmerNumber']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['centralId'])): ?>
          <tr>
            <td><strong>Central Id</strong></td>
            <td><?= htmlspecialchars($response['centralId']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['verifiedOn'])): ?>
          <tr>
            <td><strong>Verified On</strong></td>
            <td><?= htmlspecialchars($response['verifiedOn']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['enrollmentDate'])): ?>
          <tr>
            <td><strong>Enrollment Date</strong></td>
            <td><?= htmlspecialchars($response['enrollmentDate']); ?></td>
          </tr>
          <?php endif; ?>
          
          <?php if (!empty($response['verificationRemarks'])): ?>
          <tr>
            <td><strong>Remark</strong></td>
            <td><?= htmlspecialchars($response['verificationRemarks']); ?></td>
          </tr>
          <?php endif; ?>
          
        </tbody>
      </table>
    </div>
  </div>
</div>

    <?php } ?>
  <script>
function printBill() {
    var content = document.getElementById("printSection").innerHTML;

    var printWindow = window.open('', '_blank', 'width=800,height=600');
    printWindow.document.write(`
        <html>
            <head>
                <title>Farmer Status</title>
                <style>
                    body { font-family: Arial, sans-serif; padding: 20px; }
                    table { width: 100%; border-collapse: collapse; }
                    th, td { border: 1px solid #000; padding: 8px; text-align: left; }
                    th { background-color: #f2f2f2; }
                    h5 { margin-bottom: 20px; }
                </style>
            </head>
            <body>
                ${content}
                <script>
                    window.onload = function() {
                        window.print();
                    };
                <\/script>
            </body>
        </html>
    `);
    printWindow.document.close();
}
</script>  
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- Init Select2 -->
<script>
$(document).ready(function () {
    $('#operator').on('change', function () {
        var selectedOpId = $(this).find(':selected').data('opid');
        $('#opid').val(selectedOpId);
    });
    $('#operator').select2({
        placeholder: "-- Select Operator --",
        allowClear: true,
        width: '100%'
    });
});
</script>
</div>
<?php
} else {
    require_once("404.php");
}
} else {
    awal_alert_msg('You Do Not Have Any Farmer Service Active!', 'info', 'dashboard');
}

require_once("../layouts/members/foot.php");
?>
