<?php
require_once("../layouts/members/head.php");
?>
<div class="row">
  <div class="col-md-12 mb-2">
    <span class="font-weight-bold">Hi, <?= htmlspecialchars($user_data['name']) ?></span>
    <button class="btn btn-danger btn-sm ml-auto" onclick="history.back()"> 
      <i class="fas fa-arrow-left"></i> Go Back
    </button>
  </div>
  <!-- Service Cards -->
  <?php 
  $services = [
    ['link' => 'Npci_Link_Status', 'img' => 'npci.png', 'text' => 'NPCI Bank Status', 'bg' => '#ffe6e6', 'show' => $user_data['npci_service'] === "YES"],
    ['link' => 'Rtps_Certificate', 'img' => 'rtps.png', 'text' => 'RTPS PDF', 'bg' => '#e1e6ed', 'show' => $user_data['rtps_service'] === "YES"],
    ['link' => 'ifsc_code_search', 'img' => 'ifsccodes.png', 'text' => 'IFSC Code Search', 'bg' => '#ffe6e6'],
    ['link' => 'Pincode_Search', 'img' => 'pincode.png', 'text' => 'Pincode Verify', 'bg' => '#e6f7ff'],
    ['link' => 'Mobile_Operator_Verify', 'img' => 'mobileverify1.png', 'text' => 'Mobile Verify', 'bg' => '#fff5e6'],
    ['link' => 'aadhartomaskpan', 'img' => 'best-credit-card-2.png', 'text' => 'Aadhar to Mask Pan', 'bg' => '#e1e6ed'],
    ['link' => 'Pantomaskaadhaar', 'img' => 'maskaadhar.png', 'text' => 'PAN to Mask Aadhar', 'bg' => '#e6ffe6'],
    ['link' => 'PanuidLinkStatuscheck', 'img' => 'panaadharlink.png', 'text' => 'Pan Aadhar Link', 'bg' => '#f2e6ff'],
    ['link' => 'Aadhar_Verify', 'img' => 'Aadhar-status-1.jpg', 'text' => 'Aadhar No. Verify', 'bg' => '#ffe6e6'],
    ['link' => 'Enrollment_Status', 'img' => 'eiddstatus.png', 'text' => 'Enrollment Status', 'bg' => '#e6f7ff'],
  ];
  
  foreach ($services as $service): ?>
    <div class="col-lg-2 col-md-6 col-6 mb-3 hand d-flex justify-content-center">
      <div class="circle-card" 
           style="
             width: 150px;
             height: 150px;
             background: <?= htmlspecialchars($service['bg']) ?>;
             border-radius: 50%;
             overflow: hidden;
             display: flex;
             flex-direction: column;
             align-items: center;
             justify-content: center;
             box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2);
             cursor: pointer;
             position: relative;
             color: #0b0c0d;
           " 
           onclick="location.href='<?= $service['link'] ?>'">
        <div class="circle-icon">
          <img src="../layouts/members/assets/images/<?= htmlspecialchars($service['img']) ?>" 
               alt="<?= htmlspecialchars($service['text']) ?>" 
               style="max-width: 80px; max-height: 80px;">
        </div>
        <p class="circle-text" style="margin: 10px 0 0; font-size: 14px; text-align: center;"><?= htmlspecialchars($service['text']) ?></p>
      </div>
    </div>
  <?php endforeach; ?>
</div>

<?php
require_once("../layouts/members/foot.php");
?>
