<!-- =============================
     CALL TO ACTION SECTION
============================= -->
<section class="py-5 position-relative bg-light">
  <!-- .sticker -->
  <div class="sticker">
    <div class="sticker-item sticker-bottom-left w-100">
      <!-- wave1.svg -->
      <svg xmlns="http://www.w3.org/2000/svg" width="100%" height="120" viewBox="0 0 1440 240" preserveAspectRatio="none">
        <path class="fill-black" fill-rule="evenodd"
          d="M1070.39 25.041c107.898 11.22 244.461 20.779 369.477 51.164L1440 240H0L.133 72.135C350.236-17.816 721.61-11.228 1070.391 25.04z" />
      </svg>
    </div>
  </div> 
  <!-- /.sticker -->

  <!-- .container -->
  <div class="container">
    <!-- .card -->
    <div class="card bg-success text-white position-relative overflow-hidden shadow rounded-lg p-4 mb-0" data-aos="fade-up">
      <!-- .sticker -->
      <div class="sticker">
        <div class="sticker-item sticker-middle-left">
          <img class="flip-y" src="fonts/bubble4.svg" alt>
        </div>
      </div>
      <!-- /.sticker -->

      <!-- .card-body -->
      <div class="card-body d-md-flex justify-content-between align-items-center text-center position-relative">
        <h3 class="font-weight-normal mb-3 mb-md-0 mr-md-3">
          Got a Question About <?=isset($site_data['brand']) ? $site_data['brand'] : 'Brand'?>
        </h3>
        <a class="btn btn-lg btn-primary shadow" href="tel:<?= isset($site_data['mobile']) ? $site_data['mobile'] : '' ?>">
          Call Us <i class="fa fa-phone ml-2"></i>
        </a>
      </div>
      <!-- /.card-body -->
    </div>
    <!-- /.card -->
  </div>
  <!-- /.container -->
</section>
<!-- /call to action -->

<!-- =============================
     FOOTER SECTION (MODERN)
============================= -->
<footer class="footer-minimal text-white py-5">
  <div class="container">
    <div class="row gy-4 align-items-start">
      <!-- Brand -->
      <div class="col-md-4">
        <div class="d-flex align-items-center mb-3">
          <img src="<?=isset($site_data['logo']) ? $site_data['logo'] : 'logo'?>" alt="logo" class="me-2"
            style="width:42px;height:42px;border-radius:10px;object-fit:cover;">
          <h5 class="fw-semibold mb-0"><?=isset($site_data['brand']) ? $site_data['brand'] : 'OneTouch Pay'?></h5>
        </div>
        <p class="small text-secondary mb-1">We are happy to introduce you about <?=isset($site_data['brand']) ? $site_data['brand'] : 'Brand'?> , <?=isset($site_data['brand']) ? $site_data['brand'] : 'Brand'?> is an Fintech Services Provider Company.</p>
        <p class="small text-secondary mb-0">© <?=date("Y")?> <?=isset($site_data['brand']) ? $site_data['brand'] : 'OneTouch Pay'?> Technology Pvt. Ltd.</p>
      </div>

      <!-- Products -->
      <div class="col-6 col-md-2">
        <h6 class="fw-semibold mb-3">Products</h6>
        <ul class="list-unstyled small">
          <li><a href="#" class="footer-link">Mobile Recharge</a></li>
          <li><a href="#" class="footer-link">Electricity Bill</a></li>
          <li><a href="#" class="footer-link">Insurance</a></li>
          <li><a href="#" class="footer-link">FASTag</a></li>
          <li><a href="#" class="footer-link">AEPS / Loan</a></li>
        </ul>
      </div>

      <!-- Company -->
      <div class="col-6 col-md-2">
        <h6 class="fw-semibold mb-3">Company</h6>
        <ul class="list-unstyled small">
          <li><a href="about" class="footer-link">About Us</a></li>
          <li><a href="privacy" class="footer-link">Privacy</a></li>
          <li><a href="terms" class="footer-link">Terms</a></li>
          <li><a href="#" class="footer-link">Support</a></li>
        </ul>
      </div>

      <!-- Subscribe -->
      <div class="col-md-4">
        <h6 class="fw-semibold mb-3">Subscribe</h6>
        <form class="d-flex align-items-center">
          <input type="email" class="form-control footer-input me-2" placeholder="Work email" required>
          <button type="submit" class="btn btn-light fw-semibold px-4 rounded">Join</button>
        </form>
      </div>
    </div>
  </div>
</footer>

<!-- =============================
     FOOTER STYLES
============================= -->
<style>
.footer-minimal {
  background-color: #0b0c0f;
  border-top: 1px solid rgba(255, 255, 255, 0.05);
  color: #fff;
}
.footer-minimal h6 {
  color: #fff;
  letter-spacing: .3px;
}
.footer-link {
  color: #bbb;
  text-decoration: none;
  display: block;
  margin-bottom: 6px;
  transition: color .3s;
}
.footer-link:hover {
  color: #00bfff;
}
.footer-input {
  background-color: #141519;
  border: 1px solid #2a2a2a;
  color: #fff;
  height: 45px;
}
.footer-input:focus {
  outline: none;
  box-shadow: none;
  border-color: #007bff;
}
.btn-light {
  height: 45px;
  border-radius: 8px;
}
</style>

<!-- =============================
     JS FILES
============================= -->
</main>
<script src="layouts/home/js/jquery.min.js"></script>
<script src="layouts/home/js/popper.min.js"></script>
<script src="layouts/home/js/bootstrap.min.js"></script>
<script src="layouts/home/js/aos.js"></script>
<script src="layouts/home/js/theme.min.js"></script>
</body>
</html>
