<?php
require_once("layouts/home/header.php");
?>

<style>
/* =============================
   GLOBAL STYLES
============================= */
body {
  background-color: #f8faff;
  font-family: 'Poppins', sans-serif;
  overflow-x: hidden;
  color: #222;
}

/* =============================
   HERO SECTION
============================= */
.hero-section {
  position: relative;
  background: linear-gradient(135deg, #304b89 0%, #1c2b5b 50%, #182245 100%);
  color: #fff;
  overflow: hidden;
}
.hero-section .floating-orb {
  position: absolute;
  border-radius: 50%;
  background: radial-gradient(circle, rgba(255,255,255,0.12), transparent);
  animation: floatOrb 12s ease-in-out infinite;
  opacity: 0.3;
}
@keyframes floatOrb {
  0%, 100% { transform: translateY(0); }
  50% { transform: translateY(-30px); }
}
.btn-glow {
  background: linear-gradient(90deg, #00c6ff, #0072ff);
  color: #fff !important;
  border: none;
  border-radius: 50px;
  padding: 12px 30px;
  font-weight: 600;
  transition: all .3s ease;
  box-shadow: 0 0 20px rgba(0,114,255,.3);
}
.btn-glow:hover {
  transform: translateY(-3px);
  box-shadow: 0 0 35px rgba(0,150,255,.5);
}
.wave-divider {
  position: relative;
  bottom: -1px;
}

/* =============================
   SERVICES SECTION
============================= */
.section-dark {
  background-color: #0d1117;
  color: #fff;
}
.service-card {
  background: #161b22;
  border-radius: 18px;
  transition: all .3s ease;
  padding: 40px 25px;
  box-shadow: 0 4px 15px rgba(0,0,0,0.2);
  height: 100%;
}
.service-card:hover {
  transform: translateY(-6px);
  box-shadow: 0 8px 30px rgba(0,0,0,0.35);
}
.service-icon {
  width: 60px;
  height: 60px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%;
  color: #fff;
  font-size: 28px;
  margin-bottom: 18px;
}
.service-title {
  font-weight: 600;
  font-size: 18px;
  color: #fff;
  margin-bottom: 8px;
}
.service-desc {
  color: #c9d1d9;
  font-size: 15px;
}

/* =============================
   ABOUT / CTA SECTIONS
============================= */
.gradient-dark {
  background: linear-gradient(135deg, #304b89, #1c2b5b, #182245);
  color: #fff;
}
.gradient-dark h2 span {
  color: #00ffff;
}

/* =============================
   WHY CHOOSE US
============================= */
.list-unstyled i {
  margin-right: 10px;
}
</style>

<!-- =============================
     HERO SECTION
============================= -->
<section class="hero-section py-5">
  <div class="floating-orb" style="width:120px;height:120px;top:10%;left:20%;"></div>
  <div class="floating-orb" style="width:80px;height:80px;bottom:15%;right:25%;"></div>

  <div class="container py-5" data-aos="fade-up">
    <div class="row align-items-center">
      <div class="col-md-6 text-center text-md-left">
        <h1 class="display-5 fw-bold mb-4">
          India’s <span style="color:#00ffff;">Smartest BBPS</span> Payment & Recharge Platform
        </h1>
        <p class="lead mb-4 text-light">
          Recharge, pay bills, insurance, FASTag, AEPS and more – all with instant commission and secure payments.
        </p>
        <a href="members/createaccount" class="btn-glow mr-2">Create Account</a>
        <a href="members/login" class="btn btn-outline-light px-4 py-2">Login</a>
      </div>
      <div class="col-md-6 text-center mt-5 mt-md-0" data-aos="zoom-in">
        <i class="fa-solid fa-globe fa-9x text-info" style="opacity:0.15;"></i>
      </div>
    </div>
  </div>

  <svg class="wave-divider" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 200">
    <path fill="#f8faff" d="M0,160L80,149.3C160,139,320,117,480,122.7C640,128,800,160,960,165.3C1120,171,1280,149,1360,138.7L1440,128V200H0Z"></path>
  </svg>
</section>

<!-- =============================
     SERVICES SECTION
============================= -->
<section id="services" class="section-dark py-5">
  <div class="container text-center">
    <h2 class="fw-bold mb-4" data-aos="fade-up">Our BBPS Services</h2>
    <p class="text-secondary mb-5" data-aos="fade-up" data-aos-delay="100">
      Handle all your recharges and bill payments from one secure dashboard.
    </p>

    <div class="row justify-content-center g-4">
      <?php
      $services = [
        ['icon'=>'fa-mobile-screen','title'=>'Mobile Recharge','desc'=>'Instant prepaid & postpaid recharge for all operators.','color'=>'linear-gradient(135deg,#ff9966,#ff5e62)'],
        ['icon'=>'fa-tv','title'=>'DTH Recharge','desc'=>'Recharge any DTH provider in seconds.','color'=>'linear-gradient(135deg,#4facfe,#00f2fe)'],
        ['icon'=>'fa-bolt','title'=>'Electricity Bill','desc'=>'Pay electricity bills from any state instantly.','color'=>'linear-gradient(135deg,#43e97b,#38f9d7)'],
        ['icon'=>'fa-gas-pump','title'=>'Gas Bill','desc'=>'Pay PNG & LPG gas bills securely.','color'=>'linear-gradient(135deg,#f7971e,#ffd200)'],
        ['icon'=>'fa-shield-heart','title'=>'Insurance','desc'=>'Renew your health or vehicle insurance online.','color'=>'linear-gradient(135deg,#8E2DE2,#4A00E0)'],
        ['icon'=>'fa-road','title'=>'FASTag','desc'=>'Recharge FASTag for any bank instantly.','color'=>'linear-gradient(135deg,#00c6ff,#0072ff)'],
        ['icon'=>'fa-fingerprint','title'=>'AEPS / Micro ATM','desc'=>'Cash withdrawal, mini statement & balance check.','color'=>'linear-gradient(135deg,#00d2ff,#3a47d5)'],
        ['icon'=>'fa-hand-holding-dollar','title'=>'Loan / EMI','desc'=>'Pay EMI, broadband or postpaid bills easily.','color'=>'linear-gradient(135deg,#ff758c,#ff7eb3)'],
      ];
      foreach ($services as $i => $srv): ?>
      <div class="col-6 col-md-4 col-lg-3" data-aos="zoom-in" data-aos-delay="<?= $i * 100 ?>">
        <div class="service-card h-100">
          <div class="service-icon" style="background:<?= $srv['color'] ?>;">
            <i class="fa-solid <?= $srv['icon'] ?>"></i>
          </div>
          <h5 class="service-title"><?= $srv['title'] ?></h5>
          <p class="service-desc"><?= $srv['desc'] ?></p>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</section>

<!-- =============================
     ABOUT SECTION
============================= -->
<section class="gradient-dark py-5 text-center">
  <div class="container" data-aos="fade-up">
    <h2 class="fw-bold mb-3">Grow With <span><?= isset($site_data['brand']) ? $site_data['brand'] : 'One Touch' ?> Pay</span></h2>
    <p class="lead mb-4">
      Join the digital revolution – offer BBPS, AEPS, FASTag, and bill payments with instant commission.
    </p>
    <a href="members/createaccount" class="btn-glow">Become a Partner</a>
  </div>
</section>

<!-- =============================
     WHY CHOOSE US
============================= -->
<section class="py-5 bg-white">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-md-6" data-aos="fade-right">
        <h3 class="fw-bold mb-4">Why Choose <span style="color:#0072ff;"><?= isset($site_data['brand']) ? $site_data['brand'] : 'One Touch' ?> Pay?</span></h3>
        <ul class="list-unstyled">
          <li class="mb-3"><i class="fa fa-check-circle text-primary"></i> Certified BBPS Partner</li>
          <li class="mb-3"><i class="fa fa-check-circle text-success"></i> Instant Payment Confirmations</li>
          <li class="mb-3"><i class="fa fa-check-circle text-warning"></i> High Commission Margins</li>
          <li class="mb-3"><i class="fa fa-check-circle text-info"></i> 24/7 Wallet & API Access</li>
          <li class="mb-3"><i class="fa fa-check-circle text-danger"></i> AES-256 Secure Encryption</li>
        </ul>
      </div>
      <div class="col-md-6 text-center" data-aos="fade-left">
        <i class="fa-solid fa-network-wired fa-9x text-primary" style="opacity:0.15;"></i>
      </div>
    </div>
  </div>
</section>

<!-- =============================
     CTA SECTION
============================= -->
<section class="gradient-dark py-5 text-center">
  <div class="container" data-aos="zoom-in">
    <h2 class="fw-bold mb-3">Start Your Digital Payment Journey Today!</h2>
    <p class="lead mb-4">
      Join <strong><?= isset($site_data['brand']) ? $site_data['brand'] : 'One Touch' ?> Pay</strong> and earn from every recharge and bill payment.
    </p>
    <a href="members/createaccount" class="btn-glow">Create Account</a>
  </div>
</section>

<?php
require_once("layouts/home/footer.php");
?>
